// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ScopeConnectionState;
import java.io.IOException;

/**
 * Scope connection.
 */
@Fluent
public final class ScopeConnectionProperties implements JsonSerializable<ScopeConnectionProperties> {
    /*
     * Tenant ID.
     */
    private String tenantId;

    /*
     * Resource ID.
     */
    private String resourceId;

    /*
     * Connection State
     */
    private ScopeConnectionState connectionState;

    /*
     * A description of the scope connection.
     */
    private String description;

    /**
     * Creates an instance of ScopeConnectionProperties class.
     */
    public ScopeConnectionProperties() {
    }

    /**
     * Get the tenantId property: Tenant ID.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: Tenant ID.
     * 
     * @param tenantId the tenantId value to set.
     * @return the ScopeConnectionProperties object itself.
     */
    public ScopeConnectionProperties withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the resourceId property: Resource ID.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Resource ID.
     * 
     * @param resourceId the resourceId value to set.
     * @return the ScopeConnectionProperties object itself.
     */
    public ScopeConnectionProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the connectionState property: Connection State.
     * 
     * @return the connectionState value.
     */
    public ScopeConnectionState connectionState() {
        return this.connectionState;
    }

    /**
     * Get the description property: A description of the scope connection.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description of the scope connection.
     * 
     * @param description the description value to set.
     * @return the ScopeConnectionProperties object itself.
     */
    public ScopeConnectionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScopeConnectionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScopeConnectionProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScopeConnectionProperties.
     */
    public static ScopeConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScopeConnectionProperties deserializedScopeConnectionProperties = new ScopeConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tenantId".equals(fieldName)) {
                    deserializedScopeConnectionProperties.tenantId = reader.getString();
                } else if ("resourceId".equals(fieldName)) {
                    deserializedScopeConnectionProperties.resourceId = reader.getString();
                } else if ("connectionState".equals(fieldName)) {
                    deserializedScopeConnectionProperties.connectionState
                        = ScopeConnectionState.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedScopeConnectionProperties.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScopeConnectionProperties;
        });
    }
}
