// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of application security groups.
 */
@Fluent
public final class ApplicationSecurityGroupListResult implements JsonSerializable<ApplicationSecurityGroupListResult> {
    /*
     * A list of application security groups.
     */
    private List<ApplicationSecurityGroupInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ApplicationSecurityGroupListResult class.
     */
    public ApplicationSecurityGroupListResult() {
    }

    /**
     * Get the value property: A list of application security groups.
     * 
     * @return the value value.
     */
    public List<ApplicationSecurityGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of application security groups.
     * 
     * @param value the value value to set.
     * @return the ApplicationSecurityGroupListResult object itself.
     */
    public ApplicationSecurityGroupListResult withValue(List<ApplicationSecurityGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationSecurityGroupListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationSecurityGroupListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationSecurityGroupListResult.
     */
    public static ApplicationSecurityGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationSecurityGroupListResult deserializedApplicationSecurityGroupListResult
                = new ApplicationSecurityGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ApplicationSecurityGroupInner> value
                        = reader.readArray(reader1 -> ApplicationSecurityGroupInner.fromJson(reader1));
                    deserializedApplicationSecurityGroupListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedApplicationSecurityGroupListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationSecurityGroupListResult;
        });
    }
}
