// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the IpamPool update properties.
 */
@Fluent
public final class IpamPoolUpdateProperties implements JsonSerializable<IpamPoolUpdateProperties> {
    /*
     * The description property.
     */
    private String description;

    /*
     * String representing a friendly name for the resource.
     */
    private String displayName;

    /**
     * Creates an instance of IpamPoolUpdateProperties class.
     */
    public IpamPoolUpdateProperties() {
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the IpamPoolUpdateProperties object itself.
     */
    public IpamPoolUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: String representing a friendly name for the resource.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: String representing a friendly name for the resource.
     * 
     * @param displayName the displayName value to set.
     * @return the IpamPoolUpdateProperties object itself.
     */
    public IpamPoolUpdateProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpamPoolUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpamPoolUpdateProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpamPoolUpdateProperties.
     */
    public static IpamPoolUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpamPoolUpdateProperties deserializedIpamPoolUpdateProperties = new IpamPoolUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedIpamPoolUpdateProperties.description = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedIpamPoolUpdateProperties.displayName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpamPoolUpdateProperties;
        });
    }
}
