// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Network intent policy based services.
 */
public final class NetworkIntentPolicyBasedService extends ExpandableStringEnum<NetworkIntentPolicyBasedService> {
    /**
     * Static value None for NetworkIntentPolicyBasedService.
     */
    public static final NetworkIntentPolicyBasedService NONE = fromString("None");

    /**
     * Static value All for NetworkIntentPolicyBasedService.
     */
    public static final NetworkIntentPolicyBasedService ALL = fromString("All");

    /**
     * Static value AllowRulesOnly for NetworkIntentPolicyBasedService.
     */
    public static final NetworkIntentPolicyBasedService ALLOW_RULES_ONLY = fromString("AllowRulesOnly");

    /**
     * Creates a new instance of NetworkIntentPolicyBasedService value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NetworkIntentPolicyBasedService() {
    }

    /**
     * Creates or finds a NetworkIntentPolicyBasedService from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NetworkIntentPolicyBasedService.
     */
    public static NetworkIntentPolicyBasedService fromString(String name) {
        return fromString(name, NetworkIntentPolicyBasedService.class);
    }

    /**
     * Gets known NetworkIntentPolicyBasedService values.
     * 
     * @return known NetworkIntentPolicyBasedService values.
     */
    public static Collection<NetworkIntentPolicyBasedService> values() {
        return values(NetworkIntentPolicyBasedService.class);
    }
}
