// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The current provisioning state.
 */
public final class NspProvisioningState extends ExpandableStringEnum<NspProvisioningState> {
    /**
     * Static value Succeeded for NspProvisioningState.
     */
    public static final NspProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Creating for NspProvisioningState.
     */
    public static final NspProvisioningState CREATING = fromString("Creating");

    /**
     * Static value Updating for NspProvisioningState.
     */
    public static final NspProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Deleting for NspProvisioningState.
     */
    public static final NspProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Accepted for NspProvisioningState.
     */
    public static final NspProvisioningState ACCEPTED = fromString("Accepted");

    /**
     * Static value Failed for NspProvisioningState.
     */
    public static final NspProvisioningState FAILED = fromString("Failed");

    /**
     * Creates a new instance of NspProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NspProvisioningState() {
    }

    /**
     * Creates or finds a NspProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NspProvisioningState.
     */
    public static NspProvisioningState fromString(String name) {
        return fromString(name, NspProvisioningState.class);
    }

    /**
     * Gets known NspProvisioningState values.
     * 
     * @return known NspProvisioningState values.
     */
    public static Collection<NspProvisioningState> values() {
        return values(NspProvisioningState.class);
    }
}
