// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Vpn Client Parameters for package generation.
 */
@Fluent
public final class P2SVpnProfileParameters implements JsonSerializable<P2SVpnProfileParameters> {
    /*
     * VPN client authentication method.
     */
    private AuthenticationMethod authenticationMethod;

    /**
     * Creates an instance of P2SVpnProfileParameters class.
     */
    public P2SVpnProfileParameters() {
    }

    /**
     * Get the authenticationMethod property: VPN client authentication method.
     * 
     * @return the authenticationMethod value.
     */
    public AuthenticationMethod authenticationMethod() {
        return this.authenticationMethod;
    }

    /**
     * Set the authenticationMethod property: VPN client authentication method.
     * 
     * @param authenticationMethod the authenticationMethod value to set.
     * @return the P2SVpnProfileParameters object itself.
     */
    public P2SVpnProfileParameters withAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authenticationMethod",
            this.authenticationMethod == null ? null : this.authenticationMethod.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of P2SVpnProfileParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of P2SVpnProfileParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the P2SVpnProfileParameters.
     */
    public static P2SVpnProfileParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            P2SVpnProfileParameters deserializedP2SVpnProfileParameters = new P2SVpnProfileParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("authenticationMethod".equals(fieldName)) {
                    deserializedP2SVpnProfileParameters.authenticationMethod
                        = AuthenticationMethod.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedP2SVpnProfileParameters;
        });
    }
}
