// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Qos Traffic Profiler Port range properties.
 */
@Fluent
public final class QosPortRange implements JsonSerializable<QosPortRange> {
    /*
     * Qos Port Range start.
     */
    private Integer start;

    /*
     * Qos Port Range end.
     */
    private Integer end;

    /**
     * Creates an instance of QosPortRange class.
     */
    public QosPortRange() {
    }

    /**
     * Get the start property: Qos Port Range start.
     * 
     * @return the start value.
     */
    public Integer start() {
        return this.start;
    }

    /**
     * Set the start property: Qos Port Range start.
     * 
     * @param start the start value to set.
     * @return the QosPortRange object itself.
     */
    public QosPortRange withStart(Integer start) {
        this.start = start;
        return this;
    }

    /**
     * Get the end property: Qos Port Range end.
     * 
     * @return the end value.
     */
    public Integer end() {
        return this.end;
    }

    /**
     * Set the end property: Qos Port Range end.
     * 
     * @param end the end value to set.
     * @return the QosPortRange object itself.
     */
    public QosPortRange withEnd(Integer end) {
        this.end = end;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("start", this.start);
        jsonWriter.writeNumberField("end", this.end);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QosPortRange from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QosPortRange if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the QosPortRange.
     */
    public static QosPortRange fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QosPortRange deserializedQosPortRange = new QosPortRange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("start".equals(fieldName)) {
                    deserializedQosPortRange.start = reader.getNullable(JsonReader::getInt);
                } else if ("end".equals(fieldName)) {
                    deserializedQosPortRange.end = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQosPortRange;
        });
    }
}
