// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters that define the VM to check security groups for.
 */
@Fluent
public final class SecurityGroupViewParameters implements JsonSerializable<SecurityGroupViewParameters> {
    /*
     * ID of the target VM.
     */
    private String targetResourceId;

    /**
     * Creates an instance of SecurityGroupViewParameters class.
     */
    public SecurityGroupViewParameters() {
    }

    /**
     * Get the targetResourceId property: ID of the target VM.
     * 
     * @return the targetResourceId value.
     */
    public String targetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Set the targetResourceId property: ID of the target VM.
     * 
     * @param targetResourceId the targetResourceId value to set.
     * @return the SecurityGroupViewParameters object itself.
     */
    public SecurityGroupViewParameters withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (targetResourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property targetResourceId in model SecurityGroupViewParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SecurityGroupViewParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityGroupViewParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityGroupViewParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SecurityGroupViewParameters.
     */
    public static SecurityGroupViewParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityGroupViewParameters deserializedSecurityGroupViewParameters = new SecurityGroupViewParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetResourceId".equals(fieldName)) {
                    deserializedSecurityGroupViewParameters.targetResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityGroupViewParameters;
        });
    }
}
