/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityPerimeterProperties;
import com.azure.resourcemanager.network.models.NspProvisioningState;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;
import java.util.Map;

public final class NetworkSecurityPerimeterInner
extends Resource {
    private NetworkSecurityPerimeterProperties innerProperties;
    private SecurityPerimeterSystemData systemData;
    private String type;
    private String name;
    private String id;

    private NetworkSecurityPerimeterProperties innerProperties() {
        return this.innerProperties;
    }

    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public NetworkSecurityPerimeterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NetworkSecurityPerimeterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public NspProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String perimeterGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().perimeterGuid();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeterInner)((Object)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterInner deserializedNetworkSecurityPerimeterInner = new NetworkSecurityPerimeterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNetworkSecurityPerimeterInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.innerProperties = NetworkSecurityPerimeterProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterInner;
        }));
    }
}

