// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.network.fluent.models.NspAccessRuleInner;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in NetworkSecurityPerimeterAccessRulesClient.
 */
public interface NetworkSecurityPerimeterAccessRulesClient {
    /**
     * Gets the specified NSP access rule by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP access rule by name along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NspAccessRuleInner>> getWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, String accessRuleName);

    /**
     * Gets the specified NSP access rule by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP access rule by name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NspAccessRuleInner> getAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName);

    /**
     * Gets the specified NSP access rule by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP access rule by name along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NspAccessRuleInner> getWithResponse(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName, Context context);

    /**
     * Gets the specified NSP access rule by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP access rule by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NspAccessRuleInner get(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName);

    /**
     * Creates or updates a network access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters that hold the NspAccessRule resource to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP access rule resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NspAccessRuleInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, String accessRuleName, NspAccessRuleInner parameters);

    /**
     * Creates or updates a network access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters that hold the NspAccessRule resource to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP access rule resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NspAccessRuleInner> createOrUpdateAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName, NspAccessRuleInner parameters);

    /**
     * Creates or updates a network access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters that hold the NspAccessRule resource to be created/updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP access rule resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NspAccessRuleInner> createOrUpdateWithResponse(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, String accessRuleName, NspAccessRuleInner parameters,
        Context context);

    /**
     * Creates or updates a network access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters that hold the NspAccessRule resource to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP access rule resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NspAccessRuleInner createOrUpdate(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName, NspAccessRuleInner parameters);

    /**
     * Deletes an NSP access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName);

    /**
     * Deletes an NSP access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName);

    /**
     * Deletes an NSP access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName, Context context);

    /**
     * Deletes an NSP access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName);

    /**
     * Lists the NSP access rules in the specified NSP profile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NspAccessRuleInner> listAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, Integer top, String skipToken);

    /**
     * Lists the NSP access rules in the specified NSP profile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NspAccessRuleInner> listAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName);

    /**
     * Lists the NSP access rules in the specified NSP profile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NspAccessRuleInner> list(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName);

    /**
     * Lists the NSP access rules in the specified NSP profile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NspAccessRuleInner> list(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, Integer top, String skipToken, Context context);

    /**
     * Reconcile NSP access rules.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters for NSP access rule reconcile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Object>> reconcileWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName, Object parameters);

    /**
     * Reconcile NSP access rules.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters for NSP access rule reconcile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> reconcileAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName, Object parameters);

    /**
     * Reconcile NSP access rules.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters for NSP access rule reconcile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Object> reconcileWithResponse(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName, Object parameters, Context context);

    /**
     * Reconcile NSP access rules.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters for NSP access rule reconcile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object reconcile(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName, Object parameters);
}
