// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.network.fluent.models.OperationStatusResultInner;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * NetworkSecurityPerimeterOperationStatusesClient.
 */
public interface NetworkSecurityPerimeterOperationStatusesClient {
    /**
     * Gets the operation status for the given operation id.
     * 
     * @param location The location of network security perimeter.
     * @param operationId The operation id of the async operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the operation status for the given operation id along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<OperationStatusResultInner>> getWithResponseAsync(String location, String operationId);

    /**
     * Gets the operation status for the given operation id.
     * 
     * @param location The location of network security perimeter.
     * @param operationId The operation id of the async operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the operation status for the given operation id on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<OperationStatusResultInner> getAsync(String location, String operationId);

    /**
     * Gets the operation status for the given operation id.
     * 
     * @param location The location of network security perimeter.
     * @param operationId The operation id of the async operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the operation status for the given operation id along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<OperationStatusResultInner> getWithResponse(String location, String operationId, Context context);

    /**
     * Gets the operation status for the given operation id.
     * 
     * @param location The location of network security perimeter.
     * @param operationId The operation id of the async operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the operation status for the given operation id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    OperationStatusResultInner get(String location, String operationId);
}
