// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Private Endpoint connection on an application gateway.
 */
@Fluent
public final class ApplicationGatewayPrivateEndpointConnectionInner extends SubResource {
    /*
     * Properties of the application gateway private endpoint connection.
     */
    private ApplicationGatewayPrivateEndpointConnectionPropertiesInner innerProperties;

    /*
     * Name of the private endpoint connection on an application gateway.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ApplicationGatewayPrivateEndpointConnectionInner class.
     */
    public ApplicationGatewayPrivateEndpointConnectionInner() {
    }

    /**
     * Get the innerProperties property: Properties of the application gateway private endpoint connection.
     * 
     * @return the innerProperties value.
     */
    private ApplicationGatewayPrivateEndpointConnectionPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the private endpoint connection on an application gateway.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the private endpoint connection on an application gateway.
     * 
     * @param name the name value to set.
     * @return the ApplicationGatewayPrivateEndpointConnectionInner object itself.
     */
    public ApplicationGatewayPrivateEndpointConnectionInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationGatewayPrivateEndpointConnectionInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the privateEndpoint property: The resource of private end point.
     * 
     * @return the privateEndpoint value.
     */
    public PrivateEndpointInner privateEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoint();
    }

    /**
     * Get the privateLinkServiceConnectionState property: A collection of information about the state of the connection
     * between service consumer and provider.
     * 
     * @return the privateLinkServiceConnectionState value.
     */
    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    /**
     * Set the privateLinkServiceConnectionState property: A collection of information about the state of the connection
     * between service consumer and provider.
     * 
     * @param privateLinkServiceConnectionState the privateLinkServiceConnectionState value to set.
     * @return the ApplicationGatewayPrivateEndpointConnectionInner object itself.
     */
    public ApplicationGatewayPrivateEndpointConnectionInner
        withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayPrivateEndpointConnectionPropertiesInner();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the application gateway private endpoint connection
     * resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the linkIdentifier property: The consumer link id.
     * 
     * @return the linkIdentifier value.
     */
    public String linkIdentifier() {
        return this.innerProperties() == null ? null : this.innerProperties().linkIdentifier();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayPrivateEndpointConnectionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayPrivateEndpointConnectionInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayPrivateEndpointConnectionInner.
     */
    public static ApplicationGatewayPrivateEndpointConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayPrivateEndpointConnectionInner deserializedApplicationGatewayPrivateEndpointConnectionInner
                = new ApplicationGatewayPrivateEndpointConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateEndpointConnectionInner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateEndpointConnectionInner.innerProperties
                        = ApplicationGatewayPrivateEndpointConnectionPropertiesInner.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateEndpointConnectionInner.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateEndpointConnectionInner.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateEndpointConnectionInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayPrivateEndpointConnectionInner;
        });
    }
}
