// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NspLinkProvisioningState;
import com.azure.resourcemanager.network.models.NspLinkStatus;
import java.io.IOException;
import java.util.List;

/**
 * Properties of NSP Link resource.
 */
@Fluent
public final class NspLinkProperties implements JsonSerializable<NspLinkProperties> {
    /*
     * The provisioning state of the NSP Link resource.
     */
    private NspLinkProvisioningState provisioningState;

    /*
     * Perimeter ARM Id for the remote NSP with which the link gets created in Auto-approval mode. It should be used
     * when the NSP admin have Microsoft.Network/networkSecurityPerimeters/linkPerimeter/action permission on the remote
     * NSP resource.
     */
    private String autoApprovedRemotePerimeterResourceId;

    /*
     * Remote NSP Guid with which the link gets created.
     */
    private String remotePerimeterGuid;

    /*
     * Remote NSP location with which the link gets created.
     */
    private String remotePerimeterLocation;

    /*
     * Local Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles.
     */
    private List<String> localInboundProfiles;

    /*
     * Local Outbound profile names from which Outbound is allowed. In current version, it is readonly property and it's
     * value is set to ['*'] to allow outbound from all profiles. In later version, user will be able to modify it.
     */
    private List<String> localOutboundProfiles;

    /*
     * Remote Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles. This
     * property can only be updated in auto-approval mode.
     */
    private List<String> remoteInboundProfiles;

    /*
     * Remote Outbound profile names from which Outbound is allowed. In current version, it is readonly property and
     * it's value is set to ['*'] to allow outbound from all profiles. In later version, user will be able to modify it.
     */
    private List<String> remoteOutboundProfiles;

    /*
     * A message passed to the owner of the remote NSP link resource with this connection request. In case of
     * Auto-approved flow, it is default to 'Auto Approved'. Restricted to 140 chars.
     */
    private String description;

    /*
     * The NSP link state.
     */
    private NspLinkStatus status;

    /**
     * Creates an instance of NspLinkProperties class.
     */
    public NspLinkProperties() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the NSP Link resource.
     * 
     * @return the provisioningState value.
     */
    public NspLinkProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the autoApprovedRemotePerimeterResourceId property: Perimeter ARM Id for the remote NSP with which the link
     * gets created in Auto-approval mode. It should be used when the NSP admin have
     * Microsoft.Network/networkSecurityPerimeters/linkPerimeter/action permission on the remote NSP resource.
     * 
     * @return the autoApprovedRemotePerimeterResourceId value.
     */
    public String autoApprovedRemotePerimeterResourceId() {
        return this.autoApprovedRemotePerimeterResourceId;
    }

    /**
     * Set the autoApprovedRemotePerimeterResourceId property: Perimeter ARM Id for the remote NSP with which the link
     * gets created in Auto-approval mode. It should be used when the NSP admin have
     * Microsoft.Network/networkSecurityPerimeters/linkPerimeter/action permission on the remote NSP resource.
     * 
     * @param autoApprovedRemotePerimeterResourceId the autoApprovedRemotePerimeterResourceId value to set.
     * @return the NspLinkProperties object itself.
     */
    public NspLinkProperties withAutoApprovedRemotePerimeterResourceId(String autoApprovedRemotePerimeterResourceId) {
        this.autoApprovedRemotePerimeterResourceId = autoApprovedRemotePerimeterResourceId;
        return this;
    }

    /**
     * Get the remotePerimeterGuid property: Remote NSP Guid with which the link gets created.
     * 
     * @return the remotePerimeterGuid value.
     */
    public String remotePerimeterGuid() {
        return this.remotePerimeterGuid;
    }

    /**
     * Get the remotePerimeterLocation property: Remote NSP location with which the link gets created.
     * 
     * @return the remotePerimeterLocation value.
     */
    public String remotePerimeterLocation() {
        return this.remotePerimeterLocation;
    }

    /**
     * Get the localInboundProfiles property: Local Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles.
     * 
     * @return the localInboundProfiles value.
     */
    public List<String> localInboundProfiles() {
        return this.localInboundProfiles;
    }

    /**
     * Set the localInboundProfiles property: Local Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles.
     * 
     * @param localInboundProfiles the localInboundProfiles value to set.
     * @return the NspLinkProperties object itself.
     */
    public NspLinkProperties withLocalInboundProfiles(List<String> localInboundProfiles) {
        this.localInboundProfiles = localInboundProfiles;
        return this;
    }

    /**
     * Get the localOutboundProfiles property: Local Outbound profile names from which Outbound is allowed. In current
     * version, it is readonly property and it's value is set to ['*'] to allow outbound from all profiles. In later
     * version, user will be able to modify it.
     * 
     * @return the localOutboundProfiles value.
     */
    public List<String> localOutboundProfiles() {
        return this.localOutboundProfiles;
    }

    /**
     * Get the remoteInboundProfiles property: Remote Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles. This property can only be updated in auto-approval mode.
     * 
     * @return the remoteInboundProfiles value.
     */
    public List<String> remoteInboundProfiles() {
        return this.remoteInboundProfiles;
    }

    /**
     * Set the remoteInboundProfiles property: Remote Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles. This property can only be updated in auto-approval mode.
     * 
     * @param remoteInboundProfiles the remoteInboundProfiles value to set.
     * @return the NspLinkProperties object itself.
     */
    public NspLinkProperties withRemoteInboundProfiles(List<String> remoteInboundProfiles) {
        this.remoteInboundProfiles = remoteInboundProfiles;
        return this;
    }

    /**
     * Get the remoteOutboundProfiles property: Remote Outbound profile names from which Outbound is allowed. In current
     * version, it is readonly property and it's value is set to ['*'] to allow outbound from all profiles. In later
     * version, user will be able to modify it.
     * 
     * @return the remoteOutboundProfiles value.
     */
    public List<String> remoteOutboundProfiles() {
        return this.remoteOutboundProfiles;
    }

    /**
     * Get the description property: A message passed to the owner of the remote NSP link resource with this connection
     * request. In case of Auto-approved flow, it is default to 'Auto Approved'. Restricted to 140 chars.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A message passed to the owner of the remote NSP link resource with this connection
     * request. In case of Auto-approved flow, it is default to 'Auto Approved'. Restricted to 140 chars.
     * 
     * @param description the description value to set.
     * @return the NspLinkProperties object itself.
     */
    public NspLinkProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the status property: The NSP link state.
     * 
     * @return the status value.
     */
    public NspLinkStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("autoApprovedRemotePerimeterResourceId",
            this.autoApprovedRemotePerimeterResourceId);
        jsonWriter.writeArrayField("localInboundProfiles", this.localInboundProfiles,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("remoteInboundProfiles", this.remoteInboundProfiles,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspLinkProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspLinkProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspLinkProperties.
     */
    public static NspLinkProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspLinkProperties deserializedNspLinkProperties = new NspLinkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedNspLinkProperties.provisioningState
                        = NspLinkProvisioningState.fromString(reader.getString());
                } else if ("autoApprovedRemotePerimeterResourceId".equals(fieldName)) {
                    deserializedNspLinkProperties.autoApprovedRemotePerimeterResourceId = reader.getString();
                } else if ("remotePerimeterGuid".equals(fieldName)) {
                    deserializedNspLinkProperties.remotePerimeterGuid = reader.getString();
                } else if ("remotePerimeterLocation".equals(fieldName)) {
                    deserializedNspLinkProperties.remotePerimeterLocation = reader.getString();
                } else if ("localInboundProfiles".equals(fieldName)) {
                    List<String> localInboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspLinkProperties.localInboundProfiles = localInboundProfiles;
                } else if ("localOutboundProfiles".equals(fieldName)) {
                    List<String> localOutboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspLinkProperties.localOutboundProfiles = localOutboundProfiles;
                } else if ("remoteInboundProfiles".equals(fieldName)) {
                    List<String> remoteInboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspLinkProperties.remoteInboundProfiles = remoteInboundProfiles;
                } else if ("remoteOutboundProfiles".equals(fieldName)) {
                    List<String> remoteOutboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspLinkProperties.remoteOutboundProfiles = remoteOutboundProfiles;
                } else if ("description".equals(fieldName)) {
                    deserializedNspLinkProperties.description = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedNspLinkProperties.status = NspLinkStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspLinkProperties;
        });
    }
}
