// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NspLinkProvisioningState;
import com.azure.resourcemanager.network.models.NspLinkStatus;
import com.azure.resourcemanager.network.models.SecurityPerimeterProxyResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;
import java.util.List;

/**
 * The network security perimeter linkReference resource.
 */
@Fluent
public final class NspLinkReferenceInner extends SecurityPerimeterProxyResource {
    /*
     * Properties of the network security perimeter linkReference resource.
     */
    private NspLinkReferenceProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SecurityPerimeterSystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of NspLinkReferenceInner class.
     */
    public NspLinkReferenceInner() {
    }

    /**
     * Get the innerProperties property: Properties of the network security perimeter linkReference resource.
     * 
     * @return the innerProperties value.
     */
    private NspLinkReferenceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: The provisioning state of the NSP LinkReference resource.
     * 
     * @return the provisioningState value.
     */
    public NspLinkProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the remotePerimeterResourceId property: Perimeter ARM Id for the remote NSP with which the link is created.
     * 
     * @return the remotePerimeterResourceId value.
     */
    public String remotePerimeterResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().remotePerimeterResourceId();
    }

    /**
     * Get the remotePerimeterGuid property: Remote NSP Guid with which the link is created.
     * 
     * @return the remotePerimeterGuid value.
     */
    public String remotePerimeterGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().remotePerimeterGuid();
    }

    /**
     * Get the remotePerimeterLocation property: Remote NSP location with which the link gets created.
     * 
     * @return the remotePerimeterLocation value.
     */
    public String remotePerimeterLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().remotePerimeterLocation();
    }

    /**
     * Get the localInboundProfiles property: Local Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles.
     * 
     * @return the localInboundProfiles value.
     */
    public List<String> localInboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().localInboundProfiles();
    }

    /**
     * Set the localInboundProfiles property: Local Inbound profile names to which Inbound is allowed. Use ['*'] to
     * allow inbound to all profiles.
     * 
     * @param localInboundProfiles the localInboundProfiles value to set.
     * @return the NspLinkReferenceInner object itself.
     */
    public NspLinkReferenceInner withLocalInboundProfiles(List<String> localInboundProfiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkReferenceProperties();
        }
        this.innerProperties().withLocalInboundProfiles(localInboundProfiles);
        return this;
    }

    /**
     * Get the localOutboundProfiles property: Local Outbound profile names from which Outbound is allowed. In current
     * version, it is readonly property and it's value is set to ['*'] to allow outbound from all profiles. In later
     * version, user will be able to modify it.
     * 
     * @return the localOutboundProfiles value.
     */
    public List<String> localOutboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().localOutboundProfiles();
    }

    /**
     * Get the remoteInboundProfiles property: Remote Inbound profile names to which Inbound is allowed. ['*'] value
     * implies inbound is allowed to all profiles at remote perimeter. This property can only be updated from
     * corresponding link resource present in remote perimeter.
     * 
     * @return the remoteInboundProfiles value.
     */
    public List<String> remoteInboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteInboundProfiles();
    }

    /**
     * Get the remoteOutboundProfiles property: Remote Outbound profile names from which Outbound is allowed. ['*']
     * value implies outbound is allowed from all profiles at remote perimeter. This property can only be updated from
     * corresponding link resource present in remote perimeter.
     * 
     * @return the remoteOutboundProfiles value.
     */
    public List<String> remoteOutboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteOutboundProfiles();
    }

    /**
     * Get the description property: A message sent by the remote NSP link admin for connection request. In case of
     * Auto-approved flow, it is default to 'Auto Approved'.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Get the status property: The NSP linkReference state. It cannot be changed if link is created in auto-approval
     * mode.
     * 
     * @return the status value.
     */
    public NspLinkStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: The NSP linkReference state. It cannot be changed if link is created in auto-approval
     * mode.
     * 
     * @param status the status value to set.
     * @return the NspLinkReferenceInner object itself.
     */
    public NspLinkReferenceInner withStatus(NspLinkStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkReferenceProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (systemData() != null) {
            systemData().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspLinkReferenceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspLinkReferenceInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NspLinkReferenceInner.
     */
    public static NspLinkReferenceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspLinkReferenceInner deserializedNspLinkReferenceInner = new NspLinkReferenceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNspLinkReferenceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNspLinkReferenceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNspLinkReferenceInner.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedNspLinkReferenceInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedNspLinkReferenceInner.innerProperties = NspLinkReferenceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspLinkReferenceInner;
        });
    }
}
