// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AddressSpaceAggregationOption;
import com.azure.resourcemanager.network.models.NetworkIntentPolicyBasedService;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Defines the security admin configuration properties.
 */
@Fluent
public final class SecurityAdminConfigurationPropertiesFormat
    implements JsonSerializable<SecurityAdminConfigurationPropertiesFormat> {
    /*
     * A description of the security configuration.
     */
    private String description;

    /*
     * Enum list of network intent policy based services.
     */
    private List<NetworkIntentPolicyBasedService> applyOnNetworkIntentPolicyBasedServices;

    /*
     * Determine update behavior for changes to network groups referenced within the rules in this configuration.
     */
    private AddressSpaceAggregationOption networkGroupAddressSpaceAggregationOption;

    /*
     * The provisioning state of the resource.
     */
    private ProvisioningState provisioningState;

    /*
     * Unique identifier for this resource.
     */
    private String resourceGuid;

    /**
     * Creates an instance of SecurityAdminConfigurationPropertiesFormat class.
     */
    public SecurityAdminConfigurationPropertiesFormat() {
    }

    /**
     * Get the description property: A description of the security configuration.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description of the security configuration.
     * 
     * @param description the description value to set.
     * @return the SecurityAdminConfigurationPropertiesFormat object itself.
     */
    public SecurityAdminConfigurationPropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the applyOnNetworkIntentPolicyBasedServices property: Enum list of network intent policy based services.
     * 
     * @return the applyOnNetworkIntentPolicyBasedServices value.
     */
    public List<NetworkIntentPolicyBasedService> applyOnNetworkIntentPolicyBasedServices() {
        return this.applyOnNetworkIntentPolicyBasedServices;
    }

    /**
     * Set the applyOnNetworkIntentPolicyBasedServices property: Enum list of network intent policy based services.
     * 
     * @param applyOnNetworkIntentPolicyBasedServices the applyOnNetworkIntentPolicyBasedServices value to set.
     * @return the SecurityAdminConfigurationPropertiesFormat object itself.
     */
    public SecurityAdminConfigurationPropertiesFormat withApplyOnNetworkIntentPolicyBasedServices(
        List<NetworkIntentPolicyBasedService> applyOnNetworkIntentPolicyBasedServices) {
        this.applyOnNetworkIntentPolicyBasedServices = applyOnNetworkIntentPolicyBasedServices;
        return this;
    }

    /**
     * Get the networkGroupAddressSpaceAggregationOption property: Determine update behavior for changes to network
     * groups referenced within the rules in this configuration.
     * 
     * @return the networkGroupAddressSpaceAggregationOption value.
     */
    public AddressSpaceAggregationOption networkGroupAddressSpaceAggregationOption() {
        return this.networkGroupAddressSpaceAggregationOption;
    }

    /**
     * Set the networkGroupAddressSpaceAggregationOption property: Determine update behavior for changes to network
     * groups referenced within the rules in this configuration.
     * 
     * @param networkGroupAddressSpaceAggregationOption the networkGroupAddressSpaceAggregationOption value to set.
     * @return the SecurityAdminConfigurationPropertiesFormat object itself.
     */
    public SecurityAdminConfigurationPropertiesFormat withNetworkGroupAddressSpaceAggregationOption(
        AddressSpaceAggregationOption networkGroupAddressSpaceAggregationOption) {
        this.networkGroupAddressSpaceAggregationOption = networkGroupAddressSpaceAggregationOption;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("applyOnNetworkIntentPolicyBasedServices",
            this.applyOnNetworkIntentPolicyBasedServices,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("networkGroupAddressSpaceAggregationOption",
            this.networkGroupAddressSpaceAggregationOption == null
                ? null
                : this.networkGroupAddressSpaceAggregationOption.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityAdminConfigurationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityAdminConfigurationPropertiesFormat if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityAdminConfigurationPropertiesFormat.
     */
    public static SecurityAdminConfigurationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityAdminConfigurationPropertiesFormat deserializedSecurityAdminConfigurationPropertiesFormat
                = new SecurityAdminConfigurationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedSecurityAdminConfigurationPropertiesFormat.description = reader.getString();
                } else if ("applyOnNetworkIntentPolicyBasedServices".equals(fieldName)) {
                    List<NetworkIntentPolicyBasedService> applyOnNetworkIntentPolicyBasedServices
                        = reader.readArray(reader1 -> NetworkIntentPolicyBasedService.fromString(reader1.getString()));
                    deserializedSecurityAdminConfigurationPropertiesFormat.applyOnNetworkIntentPolicyBasedServices
                        = applyOnNetworkIntentPolicyBasedServices;
                } else if ("networkGroupAddressSpaceAggregationOption".equals(fieldName)) {
                    deserializedSecurityAdminConfigurationPropertiesFormat.networkGroupAddressSpaceAggregationOption
                        = AddressSpaceAggregationOption.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedSecurityAdminConfigurationPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedSecurityAdminConfigurationPropertiesFormat.resourceGuid = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityAdminConfigurationPropertiesFormat;
        });
    }
}
