// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Advertised Public Prefix State that denotes if the prefix is validated or not.
 */
public final class AdvertisedPublicPrefixPropertiesValidationState
    extends ExpandableStringEnum<AdvertisedPublicPrefixPropertiesValidationState> {
    /**
     * Static value NotConfigured for AdvertisedPublicPrefixPropertiesValidationState.
     */
    public static final AdvertisedPublicPrefixPropertiesValidationState NOT_CONFIGURED = fromString("NotConfigured");

    /**
     * Static value Configuring for AdvertisedPublicPrefixPropertiesValidationState.
     */
    public static final AdvertisedPublicPrefixPropertiesValidationState CONFIGURING = fromString("Configuring");

    /**
     * Static value Configured for AdvertisedPublicPrefixPropertiesValidationState.
     */
    public static final AdvertisedPublicPrefixPropertiesValidationState CONFIGURED = fromString("Configured");

    /**
     * Static value ValidationNeeded for AdvertisedPublicPrefixPropertiesValidationState.
     */
    public static final AdvertisedPublicPrefixPropertiesValidationState VALIDATION_NEEDED
        = fromString("ValidationNeeded");

    /**
     * Static value ValidationFailed for AdvertisedPublicPrefixPropertiesValidationState.
     */
    public static final AdvertisedPublicPrefixPropertiesValidationState VALIDATION_FAILED
        = fromString("ValidationFailed");

    /**
     * Static value ManualValidationNeeded for AdvertisedPublicPrefixPropertiesValidationState.
     */
    public static final AdvertisedPublicPrefixPropertiesValidationState MANUAL_VALIDATION_NEEDED
        = fromString("ManualValidationNeeded");

    /**
     * Static value AsnValidationFailed for AdvertisedPublicPrefixPropertiesValidationState.
     */
    public static final AdvertisedPublicPrefixPropertiesValidationState ASN_VALIDATION_FAILED
        = fromString("AsnValidationFailed");

    /**
     * Static value CertificateMissingInRoutingRegistry for AdvertisedPublicPrefixPropertiesValidationState.
     */
    public static final AdvertisedPublicPrefixPropertiesValidationState CERTIFICATE_MISSING_IN_ROUTING_REGISTRY
        = fromString("CertificateMissingInRoutingRegistry");

    /**
     * Static value InvalidSignatureEncoding for AdvertisedPublicPrefixPropertiesValidationState.
     */
    public static final AdvertisedPublicPrefixPropertiesValidationState INVALID_SIGNATURE_ENCODING
        = fromString("InvalidSignatureEncoding");

    /**
     * Static value SignatureVerificationFailed for AdvertisedPublicPrefixPropertiesValidationState.
     */
    public static final AdvertisedPublicPrefixPropertiesValidationState SIGNATURE_VERIFICATION_FAILED
        = fromString("SignatureVerificationFailed");

    /**
     * Creates a new instance of AdvertisedPublicPrefixPropertiesValidationState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AdvertisedPublicPrefixPropertiesValidationState() {
    }

    /**
     * Creates or finds a AdvertisedPublicPrefixPropertiesValidationState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AdvertisedPublicPrefixPropertiesValidationState.
     */
    public static AdvertisedPublicPrefixPropertiesValidationState fromString(String name) {
        return fromString(name, AdvertisedPublicPrefixPropertiesValidationState.class);
    }

    /**
     * Gets known AdvertisedPublicPrefixPropertiesValidationState values.
     * 
     * @return known AdvertisedPublicPrefixPropertiesValidationState values.
     */
    public static Collection<AdvertisedPublicPrefixPropertiesValidationState> values() {
        return values(AdvertisedPublicPrefixPropertiesValidationState.class);
    }
}
