// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The name of the sku of this Bastion Host.
 */
public final class BastionHostSkuName extends ExpandableStringEnum<BastionHostSkuName> {
    /**
     * Static value Basic for BastionHostSkuName.
     */
    public static final BastionHostSkuName BASIC = fromString("Basic");

    /**
     * Static value Standard for BastionHostSkuName.
     */
    public static final BastionHostSkuName STANDARD = fromString("Standard");

    /**
     * Static value Developer for BastionHostSkuName.
     */
    public static final BastionHostSkuName DEVELOPER = fromString("Developer");

    /**
     * Static value Premium for BastionHostSkuName.
     */
    public static final BastionHostSkuName PREMIUM = fromString("Premium");

    /**
     * Creates a new instance of BastionHostSkuName value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public BastionHostSkuName() {
    }

    /**
     * Creates or finds a BastionHostSkuName from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding BastionHostSkuName.
     */
    public static BastionHostSkuName fromString(String name) {
        return fromString(name, BastionHostSkuName.class);
    }

    /**
     * Gets known BastionHostSkuName values.
     * 
     * @return known BastionHostSkuName values.
     */
    public static Collection<BastionHostSkuName> values() {
        return values(BastionHostSkuName.class);
    }
}
