// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Contains custom Dns resolution configuration from customer.
 */
@Fluent
public final class CustomDnsConfigPropertiesFormat implements JsonSerializable<CustomDnsConfigPropertiesFormat> {
    /*
     * Fqdn that resolves to private endpoint ip address.
     */
    private String fqdn;

    /*
     * A list of private ip addresses of the private endpoint.
     */
    private List<String> ipAddresses;

    /**
     * Creates an instance of CustomDnsConfigPropertiesFormat class.
     */
    public CustomDnsConfigPropertiesFormat() {
    }

    /**
     * Get the fqdn property: Fqdn that resolves to private endpoint ip address.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Set the fqdn property: Fqdn that resolves to private endpoint ip address.
     * 
     * @param fqdn the fqdn value to set.
     * @return the CustomDnsConfigPropertiesFormat object itself.
     */
    public CustomDnsConfigPropertiesFormat withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    /**
     * Get the ipAddresses property: A list of private ip addresses of the private endpoint.
     * 
     * @return the ipAddresses value.
     */
    public List<String> ipAddresses() {
        return this.ipAddresses;
    }

    /**
     * Set the ipAddresses property: A list of private ip addresses of the private endpoint.
     * 
     * @param ipAddresses the ipAddresses value to set.
     * @return the CustomDnsConfigPropertiesFormat object itself.
     */
    public CustomDnsConfigPropertiesFormat withIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fqdn", this.fqdn);
        jsonWriter.writeArrayField("ipAddresses", this.ipAddresses, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomDnsConfigPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomDnsConfigPropertiesFormat if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomDnsConfigPropertiesFormat.
     */
    public static CustomDnsConfigPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomDnsConfigPropertiesFormat deserializedCustomDnsConfigPropertiesFormat
                = new CustomDnsConfigPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("fqdn".equals(fieldName)) {
                    deserializedCustomDnsConfigPropertiesFormat.fqdn = reader.getString();
                } else if ("ipAddresses".equals(fieldName)) {
                    List<String> ipAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomDnsConfigPropertiesFormat.ipAddresses = ipAddresses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomDnsConfigPropertiesFormat;
        });
    }
}
