// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Start packet capture parameters on virtual network gateway.
 */
@Fluent
public final class ExpressRouteFailoverStopApiParameters
    implements JsonSerializable<ExpressRouteFailoverStopApiParameters> {
    /*
     * Peering location of the test
     */
    private String peeringLocation;

    /*
     * Whether the failover simulation was successful or not
     */
    private Boolean wasSimulationSuccessful;

    /*
     * List of all the failover connections for this peering location
     */
    private List<FailoverConnectionDetails> details;

    /**
     * Creates an instance of ExpressRouteFailoverStopApiParameters class.
     */
    public ExpressRouteFailoverStopApiParameters() {
    }

    /**
     * Get the peeringLocation property: Peering location of the test.
     * 
     * @return the peeringLocation value.
     */
    public String peeringLocation() {
        return this.peeringLocation;
    }

    /**
     * Set the peeringLocation property: Peering location of the test.
     * 
     * @param peeringLocation the peeringLocation value to set.
     * @return the ExpressRouteFailoverStopApiParameters object itself.
     */
    public ExpressRouteFailoverStopApiParameters withPeeringLocation(String peeringLocation) {
        this.peeringLocation = peeringLocation;
        return this;
    }

    /**
     * Get the wasSimulationSuccessful property: Whether the failover simulation was successful or not.
     * 
     * @return the wasSimulationSuccessful value.
     */
    public Boolean wasSimulationSuccessful() {
        return this.wasSimulationSuccessful;
    }

    /**
     * Set the wasSimulationSuccessful property: Whether the failover simulation was successful or not.
     * 
     * @param wasSimulationSuccessful the wasSimulationSuccessful value to set.
     * @return the ExpressRouteFailoverStopApiParameters object itself.
     */
    public ExpressRouteFailoverStopApiParameters withWasSimulationSuccessful(Boolean wasSimulationSuccessful) {
        this.wasSimulationSuccessful = wasSimulationSuccessful;
        return this;
    }

    /**
     * Get the details property: List of all the failover connections for this peering location.
     * 
     * @return the details value.
     */
    public List<FailoverConnectionDetails> details() {
        return this.details;
    }

    /**
     * Set the details property: List of all the failover connections for this peering location.
     * 
     * @param details the details value to set.
     * @return the ExpressRouteFailoverStopApiParameters object itself.
     */
    public ExpressRouteFailoverStopApiParameters withDetails(List<FailoverConnectionDetails> details) {
        this.details = details;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (details() != null) {
            details().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("peeringLocation", this.peeringLocation);
        jsonWriter.writeBooleanField("wasSimulationSuccessful", this.wasSimulationSuccessful);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteFailoverStopApiParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteFailoverStopApiParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteFailoverStopApiParameters.
     */
    public static ExpressRouteFailoverStopApiParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteFailoverStopApiParameters deserializedExpressRouteFailoverStopApiParameters
                = new ExpressRouteFailoverStopApiParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("peeringLocation".equals(fieldName)) {
                    deserializedExpressRouteFailoverStopApiParameters.peeringLocation = reader.getString();
                } else if ("wasSimulationSuccessful".equals(fieldName)) {
                    deserializedExpressRouteFailoverStopApiParameters.wasSimulationSuccessful
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("details".equals(fieldName)) {
                    List<FailoverConnectionDetails> details
                        = reader.readArray(reader1 -> FailoverConnectionDetails.fromJson(reader1));
                    deserializedExpressRouteFailoverStopApiParameters.details = details;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteFailoverStopApiParameters;
        });
    }
}
