// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * IPv6 Circuit Connection properties for global reach.
 */
@Fluent
public final class Ipv6CircuitConnectionConfig implements JsonSerializable<Ipv6CircuitConnectionConfig> {
    /*
     * /125 IP address space to carve out customer addresses for global reach.
     */
    private String addressPrefix;

    /*
     * Express Route Circuit connection state.
     */
    private CircuitConnectionStatus circuitConnectionStatus;

    /**
     * Creates an instance of Ipv6CircuitConnectionConfig class.
     */
    public Ipv6CircuitConnectionConfig() {
    }

    /**
     * Get the addressPrefix property: /125 IP address space to carve out customer addresses for global reach.
     * 
     * @return the addressPrefix value.
     */
    public String addressPrefix() {
        return this.addressPrefix;
    }

    /**
     * Set the addressPrefix property: /125 IP address space to carve out customer addresses for global reach.
     * 
     * @param addressPrefix the addressPrefix value to set.
     * @return the Ipv6CircuitConnectionConfig object itself.
     */
    public Ipv6CircuitConnectionConfig withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    /**
     * Get the circuitConnectionStatus property: Express Route Circuit connection state.
     * 
     * @return the circuitConnectionStatus value.
     */
    public CircuitConnectionStatus circuitConnectionStatus() {
        return this.circuitConnectionStatus;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("addressPrefix", this.addressPrefix);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Ipv6CircuitConnectionConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Ipv6CircuitConnectionConfig if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the Ipv6CircuitConnectionConfig.
     */
    public static Ipv6CircuitConnectionConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Ipv6CircuitConnectionConfig deserializedIpv6CircuitConnectionConfig = new Ipv6CircuitConnectionConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("addressPrefix".equals(fieldName)) {
                    deserializedIpv6CircuitConnectionConfig.addressPrefix = reader.getString();
                } else if ("circuitConnectionStatus".equals(fieldName)) {
                    deserializedIpv6CircuitConnectionConfig.circuitConnectionStatus
                        = CircuitConnectionStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpv6CircuitConnectionConfig;
        });
    }
}
