// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VpnConnectionInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains a list of Vpn Connections
 * and a URL nextLink to get the next set of results.
 */
@Fluent
public final class ListVpnConnectionsResult implements JsonSerializable<ListVpnConnectionsResult> {
    /*
     * List of Vpn Connections.
     */
    private List<VpnConnectionInner> value;

    /*
     * URL to get the next set of operation list results if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of ListVpnConnectionsResult class.
     */
    public ListVpnConnectionsResult() {
    }

    /**
     * Get the value property: List of Vpn Connections.
     * 
     * @return the value value.
     */
    public List<VpnConnectionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of Vpn Connections.
     * 
     * @param value the value value to set.
     * @return the ListVpnConnectionsResult object itself.
     */
    public ListVpnConnectionsResult withValue(List<VpnConnectionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ListVpnConnectionsResult object itself.
     */
    public ListVpnConnectionsResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListVpnConnectionsResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListVpnConnectionsResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListVpnConnectionsResult.
     */
    public static ListVpnConnectionsResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListVpnConnectionsResult deserializedListVpnConnectionsResult = new ListVpnConnectionsResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VpnConnectionInner> value = reader.readArray(reader1 -> VpnConnectionInner.fromJson(reader1));
                    deserializedListVpnConnectionsResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedListVpnConnectionsResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListVpnConnectionsResult;
        });
    }
}
