// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VirtualApplianceSiteInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListNetworkVirtualApplianceSites API service call.
 */
@Fluent
public final class NetworkVirtualApplianceSiteListResult
    implements JsonSerializable<NetworkVirtualApplianceSiteListResult> {
    /*
     * List of Network Virtual Appliance sites.
     */
    private List<VirtualApplianceSiteInner> value;

    /*
     * URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of NetworkVirtualApplianceSiteListResult class.
     */
    public NetworkVirtualApplianceSiteListResult() {
    }

    /**
     * Get the value property: List of Network Virtual Appliance sites.
     * 
     * @return the value value.
     */
    public List<VirtualApplianceSiteInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of Network Virtual Appliance sites.
     * 
     * @param value the value value to set.
     * @return the NetworkVirtualApplianceSiteListResult object itself.
     */
    public NetworkVirtualApplianceSiteListResult withValue(List<VirtualApplianceSiteInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NetworkVirtualApplianceSiteListResult object itself.
     */
    public NetworkVirtualApplianceSiteListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkVirtualApplianceSiteListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkVirtualApplianceSiteListResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkVirtualApplianceSiteListResult.
     */
    public static NetworkVirtualApplianceSiteListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkVirtualApplianceSiteListResult deserializedNetworkVirtualApplianceSiteListResult
                = new NetworkVirtualApplianceSiteListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualApplianceSiteInner> value
                        = reader.readArray(reader1 -> VirtualApplianceSiteInner.fromJson(reader1));
                    deserializedNetworkVirtualApplianceSiteListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSiteListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkVirtualApplianceSiteListResult;
        });
    }
}
