// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Representation of basic resource information.
 */
@Fluent
public final class ResourceBasics implements JsonSerializable<ResourceBasics> {
    /*
     * ResourceId of the Azure resource.
     */
    private String resourceId;

    /*
     * List of IP address prefixes of the resource.
     */
    private List<String> addressPrefixes;

    /**
     * Creates an instance of ResourceBasics class.
     */
    public ResourceBasics() {
    }

    /**
     * Get the resourceId property: ResourceId of the Azure resource.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: ResourceId of the Azure resource.
     * 
     * @param resourceId the resourceId value to set.
     * @return the ResourceBasics object itself.
     */
    public ResourceBasics withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the addressPrefixes property: List of IP address prefixes of the resource.
     * 
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    /**
     * Set the addressPrefixes property: List of IP address prefixes of the resource.
     * 
     * @param addressPrefixes the addressPrefixes value to set.
     * @return the ResourceBasics object itself.
     */
    public ResourceBasics withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceBasics from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceBasics if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceBasics.
     */
    public static ResourceBasics fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceBasics deserializedResourceBasics = new ResourceBasics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedResourceBasics.resourceId = reader.getString();
                } else if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceBasics.addressPrefixes = addressPrefixes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceBasics;
        });
    }
}
