// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Update tags request.
 */
@Fluent
public final class UpdateTagsRequest implements JsonSerializable<UpdateTagsRequest> {
    /*
     * Network security perimeter identifier.
     */
    private String id;

    /*
     * List of tags for Network Security Perimeter
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of UpdateTagsRequest class.
     */
    public UpdateTagsRequest() {
    }

    /**
     * Get the id property: Network security perimeter identifier.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the tags property: List of tags for Network Security Perimeter.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: List of tags for Network Security Perimeter.
     * 
     * @param tags the tags value to set.
     * @return the UpdateTagsRequest object itself.
     */
    public UpdateTagsRequest withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpdateTagsRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpdateTagsRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the UpdateTagsRequest.
     */
    public static UpdateTagsRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UpdateTagsRequest deserializedUpdateTagsRequest = new UpdateTagsRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedUpdateTagsRequest.id = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedUpdateTagsRequest.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUpdateTagsRequest;
        });
    }
}
