// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Represent the current state of gateway migration.
 */
public final class VirtualNetworkGatewayMigrationState
    extends ExpandableStringEnum<VirtualNetworkGatewayMigrationState> {
    /**
     * Static value None for VirtualNetworkGatewayMigrationState.
     */
    public static final VirtualNetworkGatewayMigrationState NONE = fromString("None");

    /**
     * Static value InProgress for VirtualNetworkGatewayMigrationState.
     */
    public static final VirtualNetworkGatewayMigrationState IN_PROGRESS = fromString("InProgress");

    /**
     * Static value Succeeded for VirtualNetworkGatewayMigrationState.
     */
    public static final VirtualNetworkGatewayMigrationState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for VirtualNetworkGatewayMigrationState.
     */
    public static final VirtualNetworkGatewayMigrationState FAILED = fromString("Failed");

    /**
     * Creates a new instance of VirtualNetworkGatewayMigrationState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VirtualNetworkGatewayMigrationState() {
    }

    /**
     * Creates or finds a VirtualNetworkGatewayMigrationState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding VirtualNetworkGatewayMigrationState.
     */
    public static VirtualNetworkGatewayMigrationState fromString(String name) {
        return fromString(name, VirtualNetworkGatewayMigrationState.class);
    }

    /**
     * Gets known VirtualNetworkGatewayMigrationState values.
     * 
     * @return known VirtualNetworkGatewayMigrationState values.
     */
    public static Collection<VirtualNetworkGatewayMigrationState> values() {
        return values(VirtualNetworkGatewayMigrationState.class);
    }
}
