// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Stop packet capture parameters.
 */
@Fluent
public final class VpnGatewayPacketCaptureStopParameters
    implements JsonSerializable<VpnGatewayPacketCaptureStopParameters> {
    /*
     * SAS url for packet capture on vpn gateway.
     */
    private String sasUrl;

    /**
     * Creates an instance of VpnGatewayPacketCaptureStopParameters class.
     */
    public VpnGatewayPacketCaptureStopParameters() {
    }

    /**
     * Get the sasUrl property: SAS url for packet capture on vpn gateway.
     * 
     * @return the sasUrl value.
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set the sasUrl property: SAS url for packet capture on vpn gateway.
     * 
     * @param sasUrl the sasUrl value to set.
     * @return the VpnGatewayPacketCaptureStopParameters object itself.
     */
    public VpnGatewayPacketCaptureStopParameters withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sasUrl", this.sasUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnGatewayPacketCaptureStopParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnGatewayPacketCaptureStopParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnGatewayPacketCaptureStopParameters.
     */
    public static VpnGatewayPacketCaptureStopParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnGatewayPacketCaptureStopParameters deserializedVpnGatewayPacketCaptureStopParameters
                = new VpnGatewayPacketCaptureStopParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sasUrl".equals(fieldName)) {
                    deserializedVpnGatewayPacketCaptureStopParameters.sasUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnGatewayPacketCaptureStopParameters;
        });
    }
}
