/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.SwapResourceProperties;
import java.io.IOException;

public final class SwapResourceInner
implements JsonSerializable<SwapResourceInner> {
    private String id;
    private String name;
    private String type;
    private SwapResourceProperties properties;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public SwapResourceProperties properties() {
        return this.properties;
    }

    public SwapResourceInner withProperties(SwapResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static SwapResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (SwapResourceInner)jsonReader.readObject(reader -> {
            SwapResourceInner deserializedSwapResourceInner = new SwapResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSwapResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSwapResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSwapResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSwapResourceInner.properties = SwapResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSwapResourceInner;
        });
    }
}

