// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of IP configuration of an Azure Firewall.
 */
@Fluent
public final class AzureFirewallIpConfigurationPropertiesFormat
    implements JsonSerializable<AzureFirewallIpConfigurationPropertiesFormat> {
    /*
     * The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes.
     */
    private String privateIpAddress;

    /*
     * Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or
     * 'AzureFirewallManagementSubnet'.
     */
    private SubResource subnet;

    /*
     * Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
     */
    private SubResource publicIpAddress;

    /*
     * The provisioning state of the Azure firewall IP configuration resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of AzureFirewallIpConfigurationPropertiesFormat class.
     */
    public AzureFirewallIpConfigurationPropertiesFormat() {
    }

    /**
     * Get the privateIpAddress property: The Firewall Internal Load Balancer IP to be used as the next hop in User
     * Defined Routes.
     * 
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Get the subnet property: Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or
     * 'AzureFirewallManagementSubnet'.
     * 
     * @return the subnet value.
     */
    public SubResource subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or
     * 'AzureFirewallManagementSubnet'.
     * 
     * @param subnet the subnet value to set.
     * @return the AzureFirewallIpConfigurationPropertiesFormat object itself.
     */
    public AzureFirewallIpConfigurationPropertiesFormat withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the publicIpAddress property: Reference to the PublicIP resource. This field is a mandatory input if subnet
     * is not null.
     * 
     * @return the publicIpAddress value.
     */
    public SubResource publicIpAddress() {
        return this.publicIpAddress;
    }

    /**
     * Set the publicIpAddress property: Reference to the PublicIP resource. This field is a mandatory input if subnet
     * is not null.
     * 
     * @param publicIpAddress the publicIpAddress value to set.
     * @return the AzureFirewallIpConfigurationPropertiesFormat object itself.
     */
    public AzureFirewallIpConfigurationPropertiesFormat withPublicIpAddress(SubResource publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the Azure firewall IP configuration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", this.subnet);
        jsonWriter.writeJsonField("publicIPAddress", this.publicIpAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirewallIpConfigurationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirewallIpConfigurationPropertiesFormat if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirewallIpConfigurationPropertiesFormat.
     */
    public static AzureFirewallIpConfigurationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallIpConfigurationPropertiesFormat deserializedAzureFirewallIpConfigurationPropertiesFormat
                = new AzureFirewallIpConfigurationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privateIPAddress".equals(fieldName)) {
                    deserializedAzureFirewallIpConfigurationPropertiesFormat.privateIpAddress = reader.getString();
                } else if ("subnet".equals(fieldName)) {
                    deserializedAzureFirewallIpConfigurationPropertiesFormat.subnet = SubResource.fromJson(reader);
                } else if ("publicIPAddress".equals(fieldName)) {
                    deserializedAzureFirewallIpConfigurationPropertiesFormat.publicIpAddress
                        = SubResource.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedAzureFirewallIpConfigurationPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirewallIpConfigurationPropertiesFormat;
        });
    }
}
