// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The IpamPoolPrefixAllocationPool model.
 */
@Fluent
public final class IpamPoolPrefixAllocationPool implements JsonSerializable<IpamPoolPrefixAllocationPool> {
    /*
     * Resource id of the associated Azure IpamPool resource.
     */
    private String id;

    /**
     * Creates an instance of IpamPoolPrefixAllocationPool class.
     */
    public IpamPoolPrefixAllocationPool() {
    }

    /**
     * Get the id property: Resource id of the associated Azure IpamPool resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource id of the associated Azure IpamPool resource.
     * 
     * @param id the id value to set.
     * @return the IpamPoolPrefixAllocationPool object itself.
     */
    public IpamPoolPrefixAllocationPool withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpamPoolPrefixAllocationPool from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpamPoolPrefixAllocationPool if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpamPoolPrefixAllocationPool.
     */
    public static IpamPoolPrefixAllocationPool fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpamPoolPrefixAllocationPool deserializedIpamPoolPrefixAllocationPool = new IpamPoolPrefixAllocationPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedIpamPoolPrefixAllocationPool.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpamPoolPrefixAllocationPool;
        });
    }
}
