// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NspProvisioningState;
import java.io.IOException;

/**
 * Properties of network security perimeter.
 */
@Immutable
public final class NetworkSecurityPerimeterProperties implements JsonSerializable<NetworkSecurityPerimeterProperties> {
    /*
     * The provisioning state of the scope assignment resource.
     */
    private NspProvisioningState provisioningState;

    /*
     * perimeter guid of the network security perimeter.
     */
    private String perimeterGuid;

    /**
     * Creates an instance of NetworkSecurityPerimeterProperties class.
     */
    public NetworkSecurityPerimeterProperties() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the scope assignment resource.
     * 
     * @return the provisioningState value.
     */
    public NspProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the perimeterGuid property: perimeter guid of the network security perimeter.
     * 
     * @return the perimeterGuid value.
     */
    public String perimeterGuid() {
        return this.perimeterGuid;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityPerimeterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityPerimeterProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkSecurityPerimeterProperties.
     */
    public static NetworkSecurityPerimeterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterProperties deserializedNetworkSecurityPerimeterProperties
                = new NetworkSecurityPerimeterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterProperties.provisioningState
                        = NspProvisioningState.fromString(reader.getString());
                } else if ("perimeterGuid".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterProperties.perimeterGuid = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityPerimeterProperties;
        });
    }
}
