// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.LoadBalancerOutboundRuleProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Outbound rule of the load balancer.
 */
@Fluent
public final class OutboundRulePropertiesFormat implements JsonSerializable<OutboundRulePropertiesFormat> {
    /*
     * The number of outbound ports to be used for NAT.
     */
    private Integer allocatedOutboundPorts;

    /*
     * The Frontend IP addresses of the load balancer.
     */
    private List<SubResource> frontendIpConfigurations;

    /*
     * A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
     */
    private SubResource backendAddressPool;

    /*
     * The provisioning state of the outbound rule resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The protocol for the outbound rule in load balancer.
     */
    private LoadBalancerOutboundRuleProtocol protocol;

    /*
     * Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is
     * only used when the protocol is set to TCP.
     */
    private Boolean enableTcpReset;

    /*
     * The timeout for the TCP idle connection.
     */
    private Integer idleTimeoutInMinutes;

    /**
     * Creates an instance of OutboundRulePropertiesFormat class.
     */
    public OutboundRulePropertiesFormat() {
    }

    /**
     * Get the allocatedOutboundPorts property: The number of outbound ports to be used for NAT.
     * 
     * @return the allocatedOutboundPorts value.
     */
    public Integer allocatedOutboundPorts() {
        return this.allocatedOutboundPorts;
    }

    /**
     * Set the allocatedOutboundPorts property: The number of outbound ports to be used for NAT.
     * 
     * @param allocatedOutboundPorts the allocatedOutboundPorts value to set.
     * @return the OutboundRulePropertiesFormat object itself.
     */
    public OutboundRulePropertiesFormat withAllocatedOutboundPorts(Integer allocatedOutboundPorts) {
        this.allocatedOutboundPorts = allocatedOutboundPorts;
        return this;
    }

    /**
     * Get the frontendIpConfigurations property: The Frontend IP addresses of the load balancer.
     * 
     * @return the frontendIpConfigurations value.
     */
    public List<SubResource> frontendIpConfigurations() {
        return this.frontendIpConfigurations;
    }

    /**
     * Set the frontendIpConfigurations property: The Frontend IP addresses of the load balancer.
     * 
     * @param frontendIpConfigurations the frontendIpConfigurations value to set.
     * @return the OutboundRulePropertiesFormat object itself.
     */
    public OutboundRulePropertiesFormat withFrontendIpConfigurations(List<SubResource> frontendIpConfigurations) {
        this.frontendIpConfigurations = frontendIpConfigurations;
        return this;
    }

    /**
     * Get the backendAddressPool property: A reference to a pool of DIPs. Outbound traffic is randomly load balanced
     * across IPs in the backend IPs.
     * 
     * @return the backendAddressPool value.
     */
    public SubResource backendAddressPool() {
        return this.backendAddressPool;
    }

    /**
     * Set the backendAddressPool property: A reference to a pool of DIPs. Outbound traffic is randomly load balanced
     * across IPs in the backend IPs.
     * 
     * @param backendAddressPool the backendAddressPool value to set.
     * @return the OutboundRulePropertiesFormat object itself.
     */
    public OutboundRulePropertiesFormat withBackendAddressPool(SubResource backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the outbound rule resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the protocol property: The protocol for the outbound rule in load balancer.
     * 
     * @return the protocol value.
     */
    public LoadBalancerOutboundRuleProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The protocol for the outbound rule in load balancer.
     * 
     * @param protocol the protocol value to set.
     * @return the OutboundRulePropertiesFormat object itself.
     */
    public OutboundRulePropertiesFormat withProtocol(LoadBalancerOutboundRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the enableTcpReset property: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     * connection termination. This element is only used when the protocol is set to TCP.
     * 
     * @return the enableTcpReset value.
     */
    public Boolean enableTcpReset() {
        return this.enableTcpReset;
    }

    /**
     * Set the enableTcpReset property: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     * connection termination. This element is only used when the protocol is set to TCP.
     * 
     * @param enableTcpReset the enableTcpReset value to set.
     * @return the OutboundRulePropertiesFormat object itself.
     */
    public OutboundRulePropertiesFormat withEnableTcpReset(Boolean enableTcpReset) {
        this.enableTcpReset = enableTcpReset;
        return this;
    }

    /**
     * Get the idleTimeoutInMinutes property: The timeout for the TCP idle connection.
     * 
     * @return the idleTimeoutInMinutes value.
     */
    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    /**
     * Set the idleTimeoutInMinutes property: The timeout for the TCP idle connection.
     * 
     * @param idleTimeoutInMinutes the idleTimeoutInMinutes value to set.
     * @return the OutboundRulePropertiesFormat object itself.
     */
    public OutboundRulePropertiesFormat withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (frontendIpConfigurations() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property frontendIpConfigurations in model OutboundRulePropertiesFormat"));
        }
        if (backendAddressPool() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property backendAddressPool in model OutboundRulePropertiesFormat"));
        }
        if (protocol() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property protocol in model OutboundRulePropertiesFormat"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OutboundRulePropertiesFormat.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("frontendIPConfigurations", this.frontendIpConfigurations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("backendAddressPool", this.backendAddressPool);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeNumberField("allocatedOutboundPorts", this.allocatedOutboundPorts);
        jsonWriter.writeBooleanField("enableTcpReset", this.enableTcpReset);
        jsonWriter.writeNumberField("idleTimeoutInMinutes", this.idleTimeoutInMinutes);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OutboundRulePropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OutboundRulePropertiesFormat if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OutboundRulePropertiesFormat.
     */
    public static OutboundRulePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OutboundRulePropertiesFormat deserializedOutboundRulePropertiesFormat = new OutboundRulePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("frontendIPConfigurations".equals(fieldName)) {
                    List<SubResource> frontendIpConfigurations
                        = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedOutboundRulePropertiesFormat.frontendIpConfigurations = frontendIpConfigurations;
                } else if ("backendAddressPool".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.backendAddressPool = SubResource.fromJson(reader);
                } else if ("protocol".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.protocol
                        = LoadBalancerOutboundRuleProtocol.fromString(reader.getString());
                } else if ("allocatedOutboundPorts".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.allocatedOutboundPorts
                        = reader.getNullable(JsonReader::getInt);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("enableTcpReset".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.enableTcpReset
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedOutboundRulePropertiesFormat.idleTimeoutInMinutes
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOutboundRulePropertiesFormat;
        });
    }
}
