// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.PrivateDnsZoneConfig;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the private dns zone group.
 */
@Fluent
public final class PrivateDnsZoneGroupPropertiesFormat
    implements JsonSerializable<PrivateDnsZoneGroupPropertiesFormat> {
    /*
     * The provisioning state of the private dns zone group resource.
     */
    private ProvisioningState provisioningState;

    /*
     * A collection of private dns zone configurations of the private dns zone group.
     */
    private List<PrivateDnsZoneConfig> privateDnsZoneConfigs;

    /**
     * Creates an instance of PrivateDnsZoneGroupPropertiesFormat class.
     */
    public PrivateDnsZoneGroupPropertiesFormat() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the private dns zone group resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the privateDnsZoneConfigs property: A collection of private dns zone configurations of the private dns zone
     * group.
     * 
     * @return the privateDnsZoneConfigs value.
     */
    public List<PrivateDnsZoneConfig> privateDnsZoneConfigs() {
        return this.privateDnsZoneConfigs;
    }

    /**
     * Set the privateDnsZoneConfigs property: A collection of private dns zone configurations of the private dns zone
     * group.
     * 
     * @param privateDnsZoneConfigs the privateDnsZoneConfigs value to set.
     * @return the PrivateDnsZoneGroupPropertiesFormat object itself.
     */
    public PrivateDnsZoneGroupPropertiesFormat
        withPrivateDnsZoneConfigs(List<PrivateDnsZoneConfig> privateDnsZoneConfigs) {
        this.privateDnsZoneConfigs = privateDnsZoneConfigs;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateDnsZoneConfigs() != null) {
            privateDnsZoneConfigs().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("privateDnsZoneConfigs", this.privateDnsZoneConfigs,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateDnsZoneGroupPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateDnsZoneGroupPropertiesFormat if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateDnsZoneGroupPropertiesFormat.
     */
    public static PrivateDnsZoneGroupPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateDnsZoneGroupPropertiesFormat deserializedPrivateDnsZoneGroupPropertiesFormat
                = new PrivateDnsZoneGroupPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedPrivateDnsZoneGroupPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("privateDnsZoneConfigs".equals(fieldName)) {
                    List<PrivateDnsZoneConfig> privateDnsZoneConfigs
                        = reader.readArray(reader1 -> PrivateDnsZoneConfig.fromJson(reader1));
                    deserializedPrivateDnsZoneGroupPropertiesFormat.privateDnsZoneConfigs = privateDnsZoneConfigs;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateDnsZoneGroupPropertiesFormat;
        });
    }
}
