// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Access mode on the association.
 */
public final class AssociationAccessMode extends ExpandableStringEnum<AssociationAccessMode> {
    /**
     * Static value Learning for AssociationAccessMode.
     */
    public static final AssociationAccessMode LEARNING = fromString("Learning");

    /**
     * Static value Enforced for AssociationAccessMode.
     */
    public static final AssociationAccessMode ENFORCED = fromString("Enforced");

    /**
     * Static value Audit for AssociationAccessMode.
     */
    public static final AssociationAccessMode AUDIT = fromString("Audit");

    /**
     * Creates a new instance of AssociationAccessMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AssociationAccessMode() {
    }

    /**
     * Creates or finds a AssociationAccessMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AssociationAccessMode.
     */
    public static AssociationAccessMode fromString(String name) {
        return fromString(name, AssociationAccessMode.class);
    }

    /**
     * Gets known AssociationAccessMode values.
     * 
     * @return known AssociationAccessMode values.
     */
    public static Collection<AssociationAccessMode> values() {
        return values(AssociationAccessMode.class);
    }
}
