// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * VPN client authentication method.
 */
public final class AuthenticationMethod extends ExpandableStringEnum<AuthenticationMethod> {
    /**
     * Static value EAPTLS for AuthenticationMethod.
     */
    public static final AuthenticationMethod EAPTLS = fromString("EAPTLS");

    /**
     * Static value EAPMSCHAPv2 for AuthenticationMethod.
     */
    public static final AuthenticationMethod EAPMSCHAPV2 = fromString("EAPMSCHAPv2");

    /**
     * Creates a new instance of AuthenticationMethod value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AuthenticationMethod() {
    }

    /**
     * Creates or finds a AuthenticationMethod from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AuthenticationMethod.
     */
    public static AuthenticationMethod fromString(String name) {
        return fromString(name, AuthenticationMethod.class);
    }

    /**
     * Gets known AuthenticationMethod values.
     * 
     * @return known AuthenticationMethod values.
     */
    public static Collection<AuthenticationMethod> values() {
        return values(AuthenticationMethod.class);
    }
}
