// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Option indicating the scale of private endpoints allowed in the connected group of the connectivity configuration.
 */
public final class ConnectedGroupPrivateEndpointsScale
    extends ExpandableStringEnum<ConnectedGroupPrivateEndpointsScale> {
    /**
     * Static value Standard for ConnectedGroupPrivateEndpointsScale.
     */
    public static final ConnectedGroupPrivateEndpointsScale STANDARD = fromString("Standard");

    /**
     * Static value HighScale for ConnectedGroupPrivateEndpointsScale.
     */
    public static final ConnectedGroupPrivateEndpointsScale HIGH_SCALE = fromString("HighScale");

    /**
     * Creates a new instance of ConnectedGroupPrivateEndpointsScale value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ConnectedGroupPrivateEndpointsScale() {
    }

    /**
     * Creates or finds a ConnectedGroupPrivateEndpointsScale from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ConnectedGroupPrivateEndpointsScale.
     */
    public static ConnectedGroupPrivateEndpointsScale fromString(String name) {
        return fromString(name, ConnectedGroupPrivateEndpointsScale.class);
    }

    /**
     * Gets known ConnectedGroupPrivateEndpointsScale values.
     * 
     * @return known ConnectedGroupPrivateEndpointsScale values.
     */
    public static Collection<ConnectedGroupPrivateEndpointsScale> values() {
        return values(ConnectedGroupPrivateEndpointsScale.class);
    }
}
