// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspAssociationInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list NSP resource associations. Contains a list of NSP resource associations and a URL link
 * to get the next set of results.
 */
@Fluent
public final class NspAssociationsListResult implements JsonSerializable<NspAssociationsListResult> {
    /*
     * Gets a page of NSP resource associations
     */
    private List<NspAssociationInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of NspAssociationsListResult class.
     */
    public NspAssociationsListResult() {
    }

    /**
     * Get the value property: Gets a page of NSP resource associations.
     * 
     * @return the value value.
     */
    public List<NspAssociationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets a page of NSP resource associations.
     * 
     * @param value the value value to set.
     * @return the NspAssociationsListResult object itself.
     */
    public NspAssociationsListResult withValue(List<NspAssociationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NspAssociationsListResult object itself.
     */
    public NspAssociationsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspAssociationsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspAssociationsListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspAssociationsListResult.
     */
    public static NspAssociationsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspAssociationsListResult deserializedNspAssociationsListResult = new NspAssociationsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NspAssociationInner> value
                        = reader.readArray(reader1 -> NspAssociationInner.fromJson(reader1));
                    deserializedNspAssociationsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedNspAssociationsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspAssociationsListResult;
        });
    }
}
