// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspLoggingConfigurationInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list NSP logging configuration. Contains a list of NSP logging configurations and a URL link
 * to get the next set of results.
 */
@Fluent
public final class NspLoggingConfigurationListResult implements JsonSerializable<NspLoggingConfigurationListResult> {
    /*
     * Gets a page of NSP logging configuration
     */
    private List<NspLoggingConfigurationInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of NspLoggingConfigurationListResult class.
     */
    public NspLoggingConfigurationListResult() {
    }

    /**
     * Get the value property: Gets a page of NSP logging configuration.
     * 
     * @return the value value.
     */
    public List<NspLoggingConfigurationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets a page of NSP logging configuration.
     * 
     * @param value the value value to set.
     * @return the NspLoggingConfigurationListResult object itself.
     */
    public NspLoggingConfigurationListResult withValue(List<NspLoggingConfigurationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NspLoggingConfigurationListResult object itself.
     */
    public NspLoggingConfigurationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspLoggingConfigurationListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspLoggingConfigurationListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspLoggingConfigurationListResult.
     */
    public static NspLoggingConfigurationListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspLoggingConfigurationListResult deserializedNspLoggingConfigurationListResult
                = new NspLoggingConfigurationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NspLoggingConfigurationInner> value
                        = reader.readArray(reader1 -> NspLoggingConfigurationInner.fromJson(reader1));
                    deserializedNspLoggingConfigurationListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedNspLoggingConfigurationListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspLoggingConfigurationListResult;
        });
    }
}
