/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ResiliencyRecommendationComponents;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class GatewayResiliencyInformationInner
implements JsonSerializable<GatewayResiliencyInformationInner> {
    private String overallScore;
    private String scoreChange;
    private String minScoreFromRecommendations;
    private String maxScoreFromRecommendations;
    private OffsetDateTime lastComputedTime;
    private OffsetDateTime nextEligibleComputeTime;
    private List<ResiliencyRecommendationComponents> components;

    public String overallScore() {
        return this.overallScore;
    }

    public GatewayResiliencyInformationInner withOverallScore(String overallScore) {
        this.overallScore = overallScore;
        return this;
    }

    public String scoreChange() {
        return this.scoreChange;
    }

    public GatewayResiliencyInformationInner withScoreChange(String scoreChange) {
        this.scoreChange = scoreChange;
        return this;
    }

    public String minScoreFromRecommendations() {
        return this.minScoreFromRecommendations;
    }

    public GatewayResiliencyInformationInner withMinScoreFromRecommendations(String minScoreFromRecommendations) {
        this.minScoreFromRecommendations = minScoreFromRecommendations;
        return this;
    }

    public String maxScoreFromRecommendations() {
        return this.maxScoreFromRecommendations;
    }

    public GatewayResiliencyInformationInner withMaxScoreFromRecommendations(String maxScoreFromRecommendations) {
        this.maxScoreFromRecommendations = maxScoreFromRecommendations;
        return this;
    }

    public OffsetDateTime lastComputedTime() {
        return this.lastComputedTime;
    }

    public GatewayResiliencyInformationInner withLastComputedTime(OffsetDateTime lastComputedTime) {
        this.lastComputedTime = lastComputedTime;
        return this;
    }

    public OffsetDateTime nextEligibleComputeTime() {
        return this.nextEligibleComputeTime;
    }

    public GatewayResiliencyInformationInner withNextEligibleComputeTime(OffsetDateTime nextEligibleComputeTime) {
        this.nextEligibleComputeTime = nextEligibleComputeTime;
        return this;
    }

    public List<ResiliencyRecommendationComponents> components() {
        return this.components;
    }

    public GatewayResiliencyInformationInner withComponents(List<ResiliencyRecommendationComponents> components) {
        this.components = components;
        return this;
    }

    public void validate() {
        if (this.components() != null) {
            this.components().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("overallScore", this.overallScore);
        jsonWriter.writeStringField("scoreChange", this.scoreChange);
        jsonWriter.writeStringField("minScoreFromRecommendations", this.minScoreFromRecommendations);
        jsonWriter.writeStringField("maxScoreFromRecommendations", this.maxScoreFromRecommendations);
        jsonWriter.writeStringField("lastComputedTime", this.lastComputedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastComputedTime));
        jsonWriter.writeStringField("nextEligibleComputeTime", this.nextEligibleComputeTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextEligibleComputeTime));
        jsonWriter.writeArrayField("components", this.components, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static GatewayResiliencyInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return (GatewayResiliencyInformationInner)jsonReader.readObject(reader -> {
            GatewayResiliencyInformationInner deserializedGatewayResiliencyInformationInner = new GatewayResiliencyInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("overallScore".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.overallScore = reader.getString();
                    continue;
                }
                if ("scoreChange".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.scoreChange = reader.getString();
                    continue;
                }
                if ("minScoreFromRecommendations".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.minScoreFromRecommendations = reader.getString();
                    continue;
                }
                if ("maxScoreFromRecommendations".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.maxScoreFromRecommendations = reader.getString();
                    continue;
                }
                if ("lastComputedTime".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.lastComputedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("nextEligibleComputeTime".equals(fieldName)) {
                    deserializedGatewayResiliencyInformationInner.nextEligibleComputeTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("components".equals(fieldName)) {
                    List components;
                    deserializedGatewayResiliencyInformationInner.components = components = reader.readArray(reader1 -> ResiliencyRecommendationComponents.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGatewayResiliencyInformationInner;
        });
    }
}

