/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.FlowLogInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkPeeringInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkPropertiesFormat;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.DhcpOptions;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.PrivateEndpointVNetPolicies;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkBgpCommunities;
import com.azure.resourcemanager.network.models.VirtualNetworkEncryption;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualNetworkInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private VirtualNetworkPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public VirtualNetworkInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private VirtualNetworkPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public VirtualNetworkInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public VirtualNetworkInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualNetworkInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public AddressSpace addressSpace() {
        return this.innerProperties() == null ? null : this.innerProperties().addressSpace();
    }

    public VirtualNetworkInner withAddressSpace(AddressSpace addressSpace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withAddressSpace(addressSpace);
        return this;
    }

    public DhcpOptions dhcpOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().dhcpOptions();
    }

    public VirtualNetworkInner withDhcpOptions(DhcpOptions dhcpOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withDhcpOptions(dhcpOptions);
        return this;
    }

    public Integer flowTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().flowTimeoutInMinutes();
    }

    public VirtualNetworkInner withFlowTimeoutInMinutes(Integer flowTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withFlowTimeoutInMinutes(flowTimeoutInMinutes);
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.innerProperties() == null ? null : this.innerProperties().subnets();
    }

    public VirtualNetworkInner withSubnets(List<SubnetInner> subnets) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withSubnets(subnets);
        return this;
    }

    public List<VirtualNetworkPeeringInner> virtualNetworkPeerings() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkPeerings();
    }

    public VirtualNetworkInner withVirtualNetworkPeerings(List<VirtualNetworkPeeringInner> virtualNetworkPeerings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withVirtualNetworkPeerings(virtualNetworkPeerings);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean enableDdosProtection() {
        return this.innerProperties() == null ? null : this.innerProperties().enableDdosProtection();
    }

    public VirtualNetworkInner withEnableDdosProtection(Boolean enableDdosProtection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withEnableDdosProtection(enableDdosProtection);
        return this;
    }

    public Boolean enableVmProtection() {
        return this.innerProperties() == null ? null : this.innerProperties().enableVmProtection();
    }

    public VirtualNetworkInner withEnableVmProtection(Boolean enableVmProtection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withEnableVmProtection(enableVmProtection);
        return this;
    }

    public SubResource ddosProtectionPlan() {
        return this.innerProperties() == null ? null : this.innerProperties().ddosProtectionPlan();
    }

    public VirtualNetworkInner withDdosProtectionPlan(SubResource ddosProtectionPlan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withDdosProtectionPlan(ddosProtectionPlan);
        return this;
    }

    public VirtualNetworkBgpCommunities bgpCommunities() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpCommunities();
    }

    public VirtualNetworkInner withBgpCommunities(VirtualNetworkBgpCommunities bgpCommunities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withBgpCommunities(bgpCommunities);
        return this;
    }

    public VirtualNetworkEncryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public VirtualNetworkInner withEncryption(VirtualNetworkEncryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public List<SubResource> ipAllocations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAllocations();
    }

    public VirtualNetworkInner withIpAllocations(List<SubResource> ipAllocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withIpAllocations(ipAllocations);
        return this;
    }

    public List<FlowLogInner> flowLogs() {
        return this.innerProperties() == null ? null : this.innerProperties().flowLogs();
    }

    public PrivateEndpointVNetPolicies privateEndpointVNetPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointVNetPolicies();
    }

    public VirtualNetworkInner withPrivateEndpointVNetPolicies(PrivateEndpointVNetPolicies privateEndpointVNetPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withPrivateEndpointVNetPolicies(privateEndpointVNetPolicies);
        return this;
    }

    public SubResource defaultPublicNatGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultPublicNatGateway();
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkInner)((Object)jsonReader.readObject(reader -> {
            VirtualNetworkInner deserializedVirtualNetworkInner = new VirtualNetworkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVirtualNetworkInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualNetworkInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVirtualNetworkInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualNetworkInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedVirtualNetworkInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualNetworkInner.innerProperties = VirtualNetworkPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVirtualNetworkInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVirtualNetworkInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkInner;
        }));
    }
}

