/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AdvertisedPublicPrefixProperties;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState;
import java.io.IOException;
import java.util.List;

public final class ExpressRouteCircuitPeeringConfig
implements JsonSerializable<ExpressRouteCircuitPeeringConfig> {
    private List<String> advertisedPublicPrefixes;
    private List<String> advertisedCommunities;
    private ExpressRouteCircuitPeeringAdvertisedPublicPrefixState advertisedPublicPrefixesState;
    private Integer legacyMode;
    private Integer customerAsn;
    private String routingRegistryName;
    private List<AdvertisedPublicPrefixProperties> advertisedPublicPrefixInfo;

    public List<String> advertisedPublicPrefixes() {
        return this.advertisedPublicPrefixes;
    }

    public ExpressRouteCircuitPeeringConfig withAdvertisedPublicPrefixes(List<String> advertisedPublicPrefixes) {
        this.advertisedPublicPrefixes = advertisedPublicPrefixes;
        return this;
    }

    public List<String> advertisedCommunities() {
        return this.advertisedCommunities;
    }

    public ExpressRouteCircuitPeeringConfig withAdvertisedCommunities(List<String> advertisedCommunities) {
        this.advertisedCommunities = advertisedCommunities;
        return this;
    }

    public ExpressRouteCircuitPeeringAdvertisedPublicPrefixState advertisedPublicPrefixesState() {
        return this.advertisedPublicPrefixesState;
    }

    public Integer legacyMode() {
        return this.legacyMode;
    }

    public ExpressRouteCircuitPeeringConfig withLegacyMode(Integer legacyMode) {
        this.legacyMode = legacyMode;
        return this;
    }

    public Integer customerAsn() {
        return this.customerAsn;
    }

    public ExpressRouteCircuitPeeringConfig withCustomerAsn(Integer customerAsn) {
        this.customerAsn = customerAsn;
        return this;
    }

    public String routingRegistryName() {
        return this.routingRegistryName;
    }

    public ExpressRouteCircuitPeeringConfig withRoutingRegistryName(String routingRegistryName) {
        this.routingRegistryName = routingRegistryName;
        return this;
    }

    public List<AdvertisedPublicPrefixProperties> advertisedPublicPrefixInfo() {
        return this.advertisedPublicPrefixInfo;
    }

    public ExpressRouteCircuitPeeringConfig withAdvertisedPublicPrefixInfo(List<AdvertisedPublicPrefixProperties> advertisedPublicPrefixInfo) {
        this.advertisedPublicPrefixInfo = advertisedPublicPrefixInfo;
        return this;
    }

    public void validate() {
        if (this.advertisedPublicPrefixInfo() != null) {
            this.advertisedPublicPrefixInfo().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("advertisedPublicPrefixes", this.advertisedPublicPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("advertisedCommunities", this.advertisedCommunities, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("legacyMode", (Number)this.legacyMode);
        jsonWriter.writeNumberField("customerASN", (Number)this.customerAsn);
        jsonWriter.writeStringField("routingRegistryName", this.routingRegistryName);
        jsonWriter.writeArrayField("advertisedPublicPrefixInfo", this.advertisedPublicPrefixInfo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteCircuitPeeringConfig fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteCircuitPeeringConfig)jsonReader.readObject(reader -> {
            ExpressRouteCircuitPeeringConfig deserializedExpressRouteCircuitPeeringConfig = new ExpressRouteCircuitPeeringConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("advertisedPublicPrefixes".equals(fieldName)) {
                    List advertisedPublicPrefixes;
                    deserializedExpressRouteCircuitPeeringConfig.advertisedPublicPrefixes = advertisedPublicPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("advertisedCommunities".equals(fieldName)) {
                    List advertisedCommunities;
                    deserializedExpressRouteCircuitPeeringConfig.advertisedCommunities = advertisedCommunities = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("advertisedPublicPrefixesState".equals(fieldName)) {
                    deserializedExpressRouteCircuitPeeringConfig.advertisedPublicPrefixesState = ExpressRouteCircuitPeeringAdvertisedPublicPrefixState.fromString(reader.getString());
                    continue;
                }
                if ("legacyMode".equals(fieldName)) {
                    deserializedExpressRouteCircuitPeeringConfig.legacyMode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("customerASN".equals(fieldName)) {
                    deserializedExpressRouteCircuitPeeringConfig.customerAsn = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("routingRegistryName".equals(fieldName)) {
                    deserializedExpressRouteCircuitPeeringConfig.routingRegistryName = reader.getString();
                    continue;
                }
                if ("advertisedPublicPrefixInfo".equals(fieldName)) {
                    List advertisedPublicPrefixInfo;
                    deserializedExpressRouteCircuitPeeringConfig.advertisedPublicPrefixInfo = advertisedPublicPrefixInfo = reader.readArray(reader1 -> AdvertisedPublicPrefixProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteCircuitPeeringConfig;
        });
    }
}

