/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.HttpHeader;
import com.azure.resourcemanager.network.models.HttpMethod;
import java.io.IOException;
import java.util.List;

public final class HttpConfiguration
implements JsonSerializable<HttpConfiguration> {
    private HttpMethod method;
    private List<HttpHeader> headers;
    private List<Integer> validStatusCodes;

    public HttpMethod method() {
        return this.method;
    }

    public HttpConfiguration withMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public List<HttpHeader> headers() {
        return this.headers;
    }

    public HttpConfiguration withHeaders(List<HttpHeader> headers) {
        this.headers = headers;
        return this;
    }

    public List<Integer> validStatusCodes() {
        return this.validStatusCodes;
    }

    public HttpConfiguration withValidStatusCodes(List<Integer> validStatusCodes) {
        this.validStatusCodes = validStatusCodes;
        return this;
    }

    public void validate() {
        if (this.headers() != null) {
            this.headers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("validStatusCodes", this.validStatusCodes, (writer, element) -> writer.writeInt(element.intValue()));
        return jsonWriter.writeEndObject();
    }

    public static HttpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (HttpConfiguration)jsonReader.readObject(reader -> {
            HttpConfiguration deserializedHttpConfiguration = new HttpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("method".equals(fieldName)) {
                    deserializedHttpConfiguration.method = HttpMethod.fromString(reader.getString());
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    List headers;
                    deserializedHttpConfiguration.headers = headers = reader.readArray(reader1 -> HttpHeader.fromJson(reader1));
                    continue;
                }
                if ("validStatusCodes".equals(fieldName)) {
                    List validStatusCodes;
                    deserializedHttpConfiguration.validStatusCodes = validStatusCodes = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpConfiguration;
        });
    }
}

