/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteConnectionProperties;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringId;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import java.io.IOException;

public final class ExpressRouteConnectionInner
extends SubResource {
    private ExpressRouteConnectionProperties innerProperties;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(ExpressRouteConnectionInner.class);

    private ExpressRouteConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ExpressRouteConnectionInner withName(String name) {
        this.name = name;
        return this;
    }

    public ExpressRouteConnectionInner withId(String id) {
        super.withId(id);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ExpressRouteCircuitPeeringId expressRouteCircuitPeering() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteCircuitPeering();
    }

    public ExpressRouteConnectionInner withExpressRouteCircuitPeering(ExpressRouteCircuitPeeringId expressRouteCircuitPeering) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteConnectionProperties();
        }
        this.innerProperties().withExpressRouteCircuitPeering(expressRouteCircuitPeering);
        return this;
    }

    public String authorizationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationKey();
    }

    public ExpressRouteConnectionInner withAuthorizationKey(String authorizationKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteConnectionProperties();
        }
        this.innerProperties().withAuthorizationKey(authorizationKey);
        return this;
    }

    public Integer routingWeight() {
        return this.innerProperties() == null ? null : this.innerProperties().routingWeight();
    }

    public ExpressRouteConnectionInner withRoutingWeight(Integer routingWeight) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteConnectionProperties();
        }
        this.innerProperties().withRoutingWeight(routingWeight);
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.innerProperties() == null ? null : this.innerProperties().enableInternetSecurity();
    }

    public ExpressRouteConnectionInner withEnableInternetSecurity(Boolean enableInternetSecurity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteConnectionProperties();
        }
        this.innerProperties().withEnableInternetSecurity(enableInternetSecurity);
        return this;
    }

    public Boolean expressRouteGatewayBypass() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteGatewayBypass();
    }

    public ExpressRouteConnectionInner withExpressRouteGatewayBypass(Boolean expressRouteGatewayBypass) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteConnectionProperties();
        }
        this.innerProperties().withExpressRouteGatewayBypass(expressRouteGatewayBypass);
        return this;
    }

    public Boolean enablePrivateLinkFastPath() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePrivateLinkFastPath();
    }

    public ExpressRouteConnectionInner withEnablePrivateLinkFastPath(Boolean enablePrivateLinkFastPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteConnectionProperties();
        }
        this.innerProperties().withEnablePrivateLinkFastPath(enablePrivateLinkFastPath);
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().routingConfiguration();
    }

    public ExpressRouteConnectionInner withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteConnectionProperties();
        }
        this.innerProperties().withRoutingConfiguration(routingConfiguration);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ExpressRouteConnectionInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteConnectionInner)((Object)jsonReader.readObject(reader -> {
            ExpressRouteConnectionInner deserializedExpressRouteConnectionInner = new ExpressRouteConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExpressRouteConnectionInner.withId(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExpressRouteConnectionInner.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRouteConnectionInner.innerProperties = ExpressRouteConnectionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteConnectionInner;
        }));
    }
}

