// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Authentication certificates properties of an application gateway.
 */
@Fluent
public final class ApplicationGatewayAuthenticationCertificatePropertiesFormat
    implements JsonSerializable<ApplicationGatewayAuthenticationCertificatePropertiesFormat> {
    /*
     * Certificate public data.
     */
    private String data;

    /*
     * The provisioning state of the authentication certificate resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayAuthenticationCertificatePropertiesFormat class.
     */
    public ApplicationGatewayAuthenticationCertificatePropertiesFormat() {
    }

    /**
     * Get the data property: Certificate public data.
     * 
     * @return the data value.
     */
    public String data() {
        return this.data;
    }

    /**
     * Set the data property: Certificate public data.
     * 
     * @param data the data value to set.
     * @return the ApplicationGatewayAuthenticationCertificatePropertiesFormat object itself.
     */
    public ApplicationGatewayAuthenticationCertificatePropertiesFormat withData(String data) {
        this.data = data;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the authentication certificate resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("data", this.data);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayAuthenticationCertificatePropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayAuthenticationCertificatePropertiesFormat if the JsonReader was pointing
     * to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * ApplicationGatewayAuthenticationCertificatePropertiesFormat.
     */
    public static ApplicationGatewayAuthenticationCertificatePropertiesFormat fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayAuthenticationCertificatePropertiesFormat deserializedApplicationGatewayAuthenticationCertificatePropertiesFormat
                = new ApplicationGatewayAuthenticationCertificatePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("data".equals(fieldName)) {
                    deserializedApplicationGatewayAuthenticationCertificatePropertiesFormat.data = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayAuthenticationCertificatePropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayAuthenticationCertificatePropertiesFormat;
        });
    }
}
