// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of Frontend IP configuration of an application gateway.
 */
@Fluent
public final class ApplicationGatewayFrontendIpConfigurationPropertiesFormat
    implements JsonSerializable<ApplicationGatewayFrontendIpConfigurationPropertiesFormat> {
    /*
     * PrivateIPAddress of the network interface IP Configuration.
     */
    private String privateIpAddress;

    /*
     * The private IP address allocation method.
     */
    private IpAllocationMethod privateIpAllocationMethod;

    /*
     * Reference to the subnet resource.
     */
    private SubResource subnet;

    /*
     * Reference to the PublicIP resource.
     */
    private SubResource publicIpAddress;

    /*
     * Reference to the application gateway private link configuration.
     */
    private SubResource privateLinkConfiguration;

    /*
     * The provisioning state of the frontend IP configuration resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayFrontendIpConfigurationPropertiesFormat class.
     */
    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat() {
    }

    /**
     * Get the privateIpAddress property: PrivateIPAddress of the network interface IP Configuration.
     * 
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Set the privateIpAddress property: PrivateIPAddress of the network interface IP Configuration.
     * 
     * @param privateIpAddress the privateIpAddress value to set.
     * @return the ApplicationGatewayFrontendIpConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    /**
     * Get the privateIpAllocationMethod property: The private IP address allocation method.
     * 
     * @return the privateIpAllocationMethod value.
     */
    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    /**
     * Set the privateIpAllocationMethod property: The private IP address allocation method.
     * 
     * @param privateIpAllocationMethod the privateIpAllocationMethod value to set.
     * @return the ApplicationGatewayFrontendIpConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat
        withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    /**
     * Get the subnet property: Reference to the subnet resource.
     * 
     * @return the subnet value.
     */
    public SubResource subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: Reference to the subnet resource.
     * 
     * @param subnet the subnet value to set.
     * @return the ApplicationGatewayFrontendIpConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the publicIpAddress property: Reference to the PublicIP resource.
     * 
     * @return the publicIpAddress value.
     */
    public SubResource publicIpAddress() {
        return this.publicIpAddress;
    }

    /**
     * Set the publicIpAddress property: Reference to the PublicIP resource.
     * 
     * @param publicIpAddress the publicIpAddress value to set.
     * @return the ApplicationGatewayFrontendIpConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withPublicIpAddress(SubResource publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    /**
     * Get the privateLinkConfiguration property: Reference to the application gateway private link configuration.
     * 
     * @return the privateLinkConfiguration value.
     */
    public SubResource privateLinkConfiguration() {
        return this.privateLinkConfiguration;
    }

    /**
     * Set the privateLinkConfiguration property: Reference to the application gateway private link configuration.
     * 
     * @param privateLinkConfiguration the privateLinkConfiguration value to set.
     * @return the ApplicationGatewayFrontendIpConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat
        withPrivateLinkConfiguration(SubResource privateLinkConfiguration) {
        this.privateLinkConfiguration = privateLinkConfiguration;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the frontend IP configuration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        jsonWriter.writeStringField("privateIPAllocationMethod",
            this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeJsonField("subnet", this.subnet);
        jsonWriter.writeJsonField("publicIPAddress", this.publicIpAddress);
        jsonWriter.writeJsonField("privateLinkConfiguration", this.privateLinkConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayFrontendIpConfigurationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayFrontendIpConfigurationPropertiesFormat if the JsonReader was pointing
     * to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * ApplicationGatewayFrontendIpConfigurationPropertiesFormat.
     */
    public static ApplicationGatewayFrontendIpConfigurationPropertiesFormat fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayFrontendIpConfigurationPropertiesFormat deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat
                = new ApplicationGatewayFrontendIpConfigurationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privateIPAddress".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.privateIpAddress
                        = reader.getString();
                } else if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.privateIpAllocationMethod
                        = IpAllocationMethod.fromString(reader.getString());
                } else if ("subnet".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.subnet
                        = SubResource.fromJson(reader);
                } else if ("publicIPAddress".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.publicIpAddress
                        = SubResource.fromJson(reader);
                } else if ("privateLinkConfiguration".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.privateLinkConfiguration
                        = SubResource.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat;
        });
    }
}
