// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AzureFirewallPacketCaptureResponseCode;
import java.io.IOException;

/**
 * Response of an Azure Firewall Packet Capture Operation.
 */
@Fluent
public final class AzureFirewallPacketCaptureResponseInner
    implements JsonSerializable<AzureFirewallPacketCaptureResponseInner> {
    /*
     * The response code of the performed packet capture operation
     */
    private AzureFirewallPacketCaptureResponseCode statusCode;

    /*
     * Localized Message String of The Result Of The Azure Firewall Packet Capture Operation
     */
    private String message;

    /**
     * Creates an instance of AzureFirewallPacketCaptureResponseInner class.
     */
    public AzureFirewallPacketCaptureResponseInner() {
    }

    /**
     * Get the statusCode property: The response code of the performed packet capture operation.
     * 
     * @return the statusCode value.
     */
    public AzureFirewallPacketCaptureResponseCode statusCode() {
        return this.statusCode;
    }

    /**
     * Set the statusCode property: The response code of the performed packet capture operation.
     * 
     * @param statusCode the statusCode value to set.
     * @return the AzureFirewallPacketCaptureResponseInner object itself.
     */
    public AzureFirewallPacketCaptureResponseInner withStatusCode(AzureFirewallPacketCaptureResponseCode statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Get the message property: Localized Message String of The Result Of The Azure Firewall Packet Capture Operation.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Localized Message String of The Result Of The Azure Firewall Packet Capture Operation.
     * 
     * @param message the message value to set.
     * @return the AzureFirewallPacketCaptureResponseInner object itself.
     */
    public AzureFirewallPacketCaptureResponseInner withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("statusCode", this.statusCode == null ? null : this.statusCode.toString());
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirewallPacketCaptureResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirewallPacketCaptureResponseInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirewallPacketCaptureResponseInner.
     */
    public static AzureFirewallPacketCaptureResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallPacketCaptureResponseInner deserializedAzureFirewallPacketCaptureResponseInner
                = new AzureFirewallPacketCaptureResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("statusCode".equals(fieldName)) {
                    deserializedAzureFirewallPacketCaptureResponseInner.statusCode
                        = AzureFirewallPacketCaptureResponseCode.fromString(reader.getString());
                } else if ("message".equals(fieldName)) {
                    deserializedAzureFirewallPacketCaptureResponseInner.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirewallPacketCaptureResponseInner;
        });
    }
}
