// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The virtual network connection reset shared key.
 */
@Fluent
public final class ConnectionResetSharedKeyInner implements JsonSerializable<ConnectionResetSharedKeyInner> {
    /*
     * The virtual network connection reset shared key length, should between 1 and 128.
     */
    private int keyLength;

    /**
     * Creates an instance of ConnectionResetSharedKeyInner class.
     */
    public ConnectionResetSharedKeyInner() {
    }

    /**
     * Get the keyLength property: The virtual network connection reset shared key length, should between 1 and 128.
     * 
     * @return the keyLength value.
     */
    public int keyLength() {
        return this.keyLength;
    }

    /**
     * Set the keyLength property: The virtual network connection reset shared key length, should between 1 and 128.
     * 
     * @param keyLength the keyLength value to set.
     * @return the ConnectionResetSharedKeyInner object itself.
     */
    public ConnectionResetSharedKeyInner withKeyLength(int keyLength) {
        this.keyLength = keyLength;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("keyLength", this.keyLength);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionResetSharedKeyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionResetSharedKeyInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectionResetSharedKeyInner.
     */
    public static ConnectionResetSharedKeyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionResetSharedKeyInner deserializedConnectionResetSharedKeyInner
                = new ConnectionResetSharedKeyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyLength".equals(fieldName)) {
                    deserializedConnectionResetSharedKeyInner.keyLength = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionResetSharedKeyInner;
        });
    }
}
