// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The NetworkVirtualApplianceInstanceId model.
 */
@Fluent
public final class NetworkVirtualApplianceInstanceIdInner
    implements JsonSerializable<NetworkVirtualApplianceInstanceIdInner> {
    /*
     * The network virtual appliance instance id for which boot diagnostic logs is being requested
     */
    private Integer instanceId;

    /**
     * Creates an instance of NetworkVirtualApplianceInstanceIdInner class.
     */
    public NetworkVirtualApplianceInstanceIdInner() {
    }

    /**
     * Get the instanceId property: The network virtual appliance instance id for which boot diagnostic logs is being
     * requested.
     * 
     * @return the instanceId value.
     */
    public Integer instanceId() {
        return this.instanceId;
    }

    /**
     * Set the instanceId property: The network virtual appliance instance id for which boot diagnostic logs is being
     * requested.
     * 
     * @param instanceId the instanceId value to set.
     * @return the NetworkVirtualApplianceInstanceIdInner object itself.
     */
    public NetworkVirtualApplianceInstanceIdInner withInstanceId(Integer instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("instanceId", this.instanceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkVirtualApplianceInstanceIdInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkVirtualApplianceInstanceIdInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkVirtualApplianceInstanceIdInner.
     */
    public static NetworkVirtualApplianceInstanceIdInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkVirtualApplianceInstanceIdInner deserializedNetworkVirtualApplianceInstanceIdInner
                = new NetworkVirtualApplianceInstanceIdInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("instanceId".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceInstanceIdInner.instanceId
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkVirtualApplianceInstanceIdInner;
        });
    }
}
