// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Resource containing list of NSP service tags.
 */
@Fluent
public final class NspServiceTagsResourceInner implements JsonSerializable<NspServiceTagsResourceInner> {
    /*
     * NSP service tags.
     */
    private List<String> serviceTags;

    /**
     * Creates an instance of NspServiceTagsResourceInner class.
     */
    public NspServiceTagsResourceInner() {
    }

    /**
     * Get the serviceTags property: NSP service tags.
     * 
     * @return the serviceTags value.
     */
    public List<String> serviceTags() {
        return this.serviceTags;
    }

    /**
     * Set the serviceTags property: NSP service tags.
     * 
     * @param serviceTags the serviceTags value to set.
     * @return the NspServiceTagsResourceInner object itself.
     */
    public NspServiceTagsResourceInner withServiceTags(List<String> serviceTags) {
        this.serviceTags = serviceTags;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("serviceTags", this.serviceTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspServiceTagsResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspServiceTagsResourceInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspServiceTagsResourceInner.
     */
    public static NspServiceTagsResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspServiceTagsResourceInner deserializedNspServiceTagsResourceInner = new NspServiceTagsResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceTags".equals(fieldName)) {
                    List<String> serviceTags = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspServiceTagsResourceInner.serviceTags = serviceTags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspServiceTagsResourceInner;
        });
    }
}
