// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.OperationPropertiesFormatServiceSpecification;
import java.io.IOException;

/**
 * Description of operation properties format.
 */
@Fluent
public final class OperationPropertiesFormat implements JsonSerializable<OperationPropertiesFormat> {
    /*
     * Specification of the service.
     */
    private OperationPropertiesFormatServiceSpecification serviceSpecification;

    /**
     * Creates an instance of OperationPropertiesFormat class.
     */
    public OperationPropertiesFormat() {
    }

    /**
     * Get the serviceSpecification property: Specification of the service.
     * 
     * @return the serviceSpecification value.
     */
    public OperationPropertiesFormatServiceSpecification serviceSpecification() {
        return this.serviceSpecification;
    }

    /**
     * Set the serviceSpecification property: Specification of the service.
     * 
     * @param serviceSpecification the serviceSpecification value to set.
     * @return the OperationPropertiesFormat object itself.
     */
    public OperationPropertiesFormat
        withServiceSpecification(OperationPropertiesFormatServiceSpecification serviceSpecification) {
        this.serviceSpecification = serviceSpecification;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (serviceSpecification() != null) {
            serviceSpecification().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("serviceSpecification", this.serviceSpecification);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationPropertiesFormat if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationPropertiesFormat.
     */
    public static OperationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationPropertiesFormat deserializedOperationPropertiesFormat = new OperationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceSpecification".equals(fieldName)) {
                    deserializedOperationPropertiesFormat.serviceSpecification
                        = OperationPropertiesFormatServiceSpecification.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationPropertiesFormat;
        });
    }
}
