// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CommonProxyResource;
import com.azure.resourcemanager.network.models.ReachabilityAnalysisRunProperties;
import java.io.IOException;

/**
 * Configuration information for analysis run.
 */
@Fluent
public final class ReachabilityAnalysisRunInner extends CommonProxyResource {
    /*
     * Represents the Reachability Analysis Run properties.
     */
    private ReachabilityAnalysisRunProperties properties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ReachabilityAnalysisRunInner class.
     */
    public ReachabilityAnalysisRunInner() {
    }

    /**
     * Get the properties property: Represents the Reachability Analysis Run properties.
     * 
     * @return the properties value.
     */
    public ReachabilityAnalysisRunProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Represents the Reachability Analysis Run properties.
     * 
     * @param properties the properties value to set.
     * @return the ReachabilityAnalysisRunInner object itself.
     */
    public ReachabilityAnalysisRunInner withProperties(ReachabilityAnalysisRunProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property properties in model ReachabilityAnalysisRunInner"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ReachabilityAnalysisRunInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReachabilityAnalysisRunInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReachabilityAnalysisRunInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ReachabilityAnalysisRunInner.
     */
    public static ReachabilityAnalysisRunInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReachabilityAnalysisRunInner deserializedReachabilityAnalysisRunInner = new ReachabilityAnalysisRunInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunInner.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunInner.systemData = SystemData.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunInner.properties
                        = ReachabilityAnalysisRunProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReachabilityAnalysisRunInner;
        });
    }
}
